;-----------------------------------------------------------------
;       puts for DOS    (Using DOS func 2)
;-----------------------------------------------------------------
                PUBLIC  puts
puts            PROC    near
                push    ax
                push    bx
                push    cx
                push    dx
                mov     bx,dx
puts2_ent:      mov     dl,[bx]
                inc     bx
                or      dl,dl
                jz      puts2_ext
                mov     ah,2
                int     21h
                jmp     puts2_ent
puts2_ext:
                pop     dx
                pop     cx
                pop     bx
                pop     ax
                ret
puts            ENDP
;--------------------------------------------------------------
;       This function is revised on      2010-11-30
;--------------------------------------------------------------
                PUBLIC  ScanLangMode
ScanLangMode    PROC    near        
                push    si
                mov     AX,4900h
                int 15h
                jc      ENG_mode
                cmp     AH,00h
                jne     ENG_mode
                cmp     BL,00h
                jne     ENG_mode
                mov     ax,3

                push    ds
                mov     si,0
                mov     ax,6300h
                int 21h
                mov     ax,[si]
                pop     ds
                test    si,0FFFFh
                jz      ENG_mode
                or      ax,ax
                jz      ENG_mode
                mov     ax,1
                jmp     BothLangMode
ENG_mode:
                mov     ax,0
BothLangMode:   or      ax,ax
                pop     si
                ret
ScanLangMode    ENDP
;---------------------------------------------------------------
;       MemAlloc64KB        
;---------------------------------------------------------------
MemAlloc64KB    PROC    near
                mov     bx,1000h        ; /  16=paragraph size
                inc     bx
                mov     ax,4800h
                int     21h
                jc      mem_err
                mov     DataBufferSeg,ax
                mov     es,ax
                xor     ax,ax
                mov     cx,8000h        ; 64KB=32KW
            rep stosw
                clc
                ret
mem_err:        mov     dx,offset msg_mAllocFail
                stc
                ret
MemAlloc64KB    ENDP
;-----------------------------------------------------------------
;       RenameFile
;-----------------------------------------------------------------
RenameFile      PROC   near
                mov     dx,offset InputFilename
                mov     di,offset AltFileName
                push    ds
                pop     es
                mov     ah,56h
                int     21h
                jnc     RenameOK
                mov     dx,offset msg_rename_fail
                call    puts
                stc
                ret
RenameOK:       clc
                ret
RenameFile      ENDP

;-----------------------------------------------------------------
;       Create_File_DX
;-----------------------------------------------------------------
Create_File_DX  PROC    near
                push    dx
                mov     dx,offset msg_creatfile
                call    puts
                pop     dx
                push    dx
                call    puts
                mov     dx,offset msg_CRLF
                call    puts
                pop     dx
                mov     cx,020h
                mov     ax,3C00h
                xor     bx,bx
                int 21h
                jc      CreateFail1
                mov     DOS_handle,ax
                clc
                ret
CreateFail1:    mov     dx,offset err_filename
                call    puts
                mov     DOS_handle,0FFFFh
                stc
                ret
Create_File_DX  ENDP

;-----------------------------------------------------------------
;       Open_File_DX    return=BX ,DOS file handle
;-----------------------------------------------------------------
Open_File_DX    PROC    near
                push    dx
                mov     dx,offset msg_openfile
                call    puts
                pop     dx
                push    dx
                call    puts
                mov     dx,offset msg_CRLF
                call    puts
                pop     dx

                mov     ax,3D00h
                xor     bx,bx
                int 21h
                jc      OpenFail1
                mov     DOS_handle,ax
                clc
                ret
OpenFail1:      mov     dx,offset msg_OpenError
                call    puts
                stc
                ret
Open_File_DX    ENDP

;-----------------------------------------------------------------
;       Save_Data64K
;-----------------------------------------------------------------
Save_Data64K    PROC   near
                mov     bx,DOS_handle
                mov     cx,ROM_SIZE_HALF 
                mov     ax,4000h
                push    ds
                lds     dx,cs:DataBuffer
                int 21h
                pop     ds
                jc      write_err1
                mov     bx,DOS_handle
                mov     cx,ROM_SIZE_HALF 
                mov     ax,4000h
                push    ds
                lds     dx,cs:DataBuffer
                add     dx,cx
                int 21h
                pop     ds
                jc      write_err1
                clc
                ret
write_err1:
                mov     dx,offset WriteErrMsg
                call    puts
                stc
                ret
Save_Data64K    ENDP

;-----------------------------------------------------------------
;       Load_Data64K       DS:DX   = file buffer, 
;-----------------------------------------------------------------
Load_Data64K    PROC    near
                mov     bx,DOS_handle    ; int21, func 3F
                mov     cx,ROM_SIZE_HALF 
                mov     dx,DataBufferOfs
                mov     ax,3F00h        ; DOS function call (read)
                push    ds
                mov     ds,cs:DataBufferSeg
                int 21h
                pop     ds
                jc      read_err1

                mov     bx,DOS_handle    ; int21, func 3F
                mov     cx,ROM_SIZE_HALF 
                mov     dx,DataBufferOfs
                add     dx,cx 
                mov     ax,3F00h        ; DOS function call (read)
                push    ds
                mov     ds,cs:DataBufferSeg
                int 21h
                pop     ds
                jc      read_err1
                cmp     ax,cx   
                jne     read_err2

                mov     bx,DOS_handle           ; close 
                call    Close_File_BX   
                clc
                ret
read_err1:      
                mov     dx,offset ReadErrMsg
                call    puts
                jmp     read_err_e
read_err2:      
                mov     dx,offset ReadErrMsg2
                call    puts
read_err_e:     
                mov     bx,DOS_handle           ; close
                call    Close_File_BX   
                stc
                ret
Load_Data64K    ENDP


;-----------------------------------------------------------------
;       Close_File_BX
;-----------------------------------------------------------------
                PUBLIC  Close_File_BX
Close_File_BX   PROC    near
                mov     ah,3Eh
                xor     dx,dx
                int     21h
                ret
Close_File_BX   ENDP
;--------------------------------------------------------------------------
err_filesize    DB "ROMf[^t@C̃TCY傫܂.",13,10,0
msg_sizeIs      DB "ROMf[^̃TCY = 65536 oCg.",13,10,0
;msg_bytes       DB " oCg",13,10,0
msg_null_exist  DB "pb`\ȋ󂫃GAiȂƂ70޲āj܂.",13,10,0
msg_null0       DB "0F9A`0FCFh Ƀpb`\ȋ󂫃GA܂.",13,10,0
msg_patched     DB 13,10,1Bh,"[36mDIV0ROMpb`ĂĂ悤ł. ",1Bh,"[m",13,10,0
msg_OpenError   DB 13,10,1Bh,"[31mROMf[^t@CI[vł܂.",13,10
                DB 13,10,1Bh,"[mt@CȂ܂̓t@Csł.",13,10,13,10,0
err_filename    DB "t@CsK؂ō쐬ł܂.",13,10,0
msg_creatfile   DB "t@C쐬܂==>",0
msg_openfile    DB "t@CI[v܂==>",0
msg_reading     DB  "t@Cf[^ǂݏo܂.",13,10,0
msg_mAllocFail  DB "DOS ̋󂫃(64KB)sĂ̂ősł܂.",13,10,0
ReadErrMsg      DB "t@Cǂݍ݂ŃG[܂.",13,10,0
ReadErrMsg2     DB "̃t@CTCYɖȂt@Cł.",13,10,0
WriteErrMsg     DB "t@C݂ŃG[܂.",13,10,0
ScanErrMsg      DB "ӏ܂ł.",13,10,0
msg_written     DB "f[^݂܂.",13,10,0
msg_rename      DB 13,10,"Ƃ̃t@C̊gq .ORG ɕύX܂.",13,10,0
msg_rename_fail DB "ύXł܂ł.",13,10,0
msg_cancel      DB 1Bh,"[33m~܂.",1Bh,"[m",13,10,0
msg_done    DB 13,10,"͐܂. I܂.",13,10,0
msg_ENG         DB "English(US) mode is not supported.   Use DOS/V JP mode.",13,10,0


