        assume  CS: code, DS:code, ES:code, SS:code
code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:
                jmp     StartDOSAPP
TitleMessage    DB "SC-98VBIOSf[^ 'DIV0ROM'pb` "
                DB "Version 1.00  Copyright(C) 2024 ܂ ",13,10,0,0
align   4
DataBuffer      label dword
DataBufferOfs   DW      0
DataBufferSeg   DW      8000h
ROM_SIZE_HALF   equ     8000h
OrgJmpAddr      DW      0000h
DOS_handle      DW     0FFFFh
flagset         DB      0
F_SC983         equ     03h
F_LHA203        equ     23h
msg_CRLF        DB 13,10,0
align   16
InputFileName   DB "SMIT.BIN",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 32 dup(0)
AltFileName     DB "SMIT.ORG",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 32 dup(0)
OutputFileName  DB "SMIT.BIN",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
                DB 32 dup(0)
.8086
StartDOSAPP:    
                mov     cx,4
                mov     bx,offset stack_base+1024        ; X^bN
                shr     bx,cl
                add     bx,17
                mov     ah,4Ah  ; gpJ
                int 21h
                mov     ax,bx
                shl     ax,cl
                dec     ax
                mov     sp,ax           ; X^bN͂ύX
                mov     dx,offset msg_CRLF
                call    puts
                mov     dx,offset TitleMessage
                call    puts
                mov     ah,00
                mov     cx,0FFFFh
                int     1Ah             ; XWǂ̃`FbN
                cmp     cx,0FFFFh
                JE      MachineEnv98
                call    ScanLangMode
                jnz     MachineEnvDOSV
                mov     dx,offset msg_ENG
                jmp     JobFinish
MachineEnvDOSV:
MachineEnv98:
                call    MemAlloc64KB
                jc      JobCancel
;;;;;           call    SelectBoard
                call    main2
                jc      JobCancel
                mov     dx,offset msg_done
                jmp     JobFinish
JobCancel:      mov     dx,offset msg_cancel
JobFinish:      call    puts
                mov     ah,4Ch        ; ُIR[h FFh
                int 21h
;=============================================
main2           PROC   near
                mov     dx,offset InputFileName
                call    Open_File_DX    ; t@C=DXŃI[v
                jc      AbortMain2
                call    Load_Data64K
                jc      AbortMain2
                mov     dx,offset msg_reading
                call    puts

                call    SC983_ScanNull
                jc      AbortMain2
                mov     dx,offset msg_null_exist
                call    puts
                call    SC983Patch

                mov     dx,offset msg_rename
                call    puts
                call    RenameFile
                jc      AbortMain2

                mov     dx,offset OutputFileName
                call    Create_File_DX
                jc      AbortMain2
                call    Save_Data64K    
                jc      AbortMain2
                mov     dx,offset msg_written
                call    puts

                clc
                ret
AbortMain2:     stc
                ret
main2           ENDP
;------------------------------
SC983_ScanNull  PROC   near
                mov     es,cs:DataBufferSeg
                mov     di,offset NewCode
                mov     si,di
                mov     cx,10
        rep     cmpsb
                jcxz    SC983_Patched
SC983_Start:
                mov     es,cs:DataBufferSeg
                mov     di,offset NewCode
                mov     al,0
                mov     cx,54
        rep     scasb
                jz      SC983_ScanNull_OK
;SC983_ScanNull_fail:
                mov     dx,offset msg_null0
                call    puts
                stc
                ret
SC983_ScanNull_OK:    clc
                ret
SC983_Patched:  mov     dx,offset msg_patched
                call    puts
                jmp     SC983_Start
SC983_ScanNull  ENDP

;=======================================
SC983Patch      PROC   near
                les     bx,cs:DataBuffer

                mov     ax,es:[bx+0Ch+1]
                add     ax,0Ch
                add     ax,3
                mov     OrgJmpAddr,ax
                
                mov     ax,offset NewCode
                sub     ax,(0Ch+3)
                mov     es:[bx+0Ch+1],ax

                mov     di,offset NewCode
                mov     si,offset NewCode
                mov     cx,( offset NewCode_End - offset NewCode )
        rep     movsb
                
                mov     di,offset Div0Code
                mov     si,offset Div0Code
                mov     cx,( offset Div0Code_End - offset Div0Code )
        rep     movsb

                mov     ax,OrgJmpAddr
                sub     ax,offset NewJmpAddr
                sub     ax,2
                mov     Div0CodeAddr,ax
                mov     es:[NewJmpAddr],ax
                clc
                ret
SC983Patch      ENDP
;=============================================
include     subrtn.inc
;=============================================

ORG     0F9Ah
NewCode         label   byte
                DB      3Eh, 0C7h, 06h, 00h, 00h ; mov  ds:[0000], (mem)
Div0CodeAddr    DW      offset Div0Code
                mov     word ptr ds:[0002h],cs
                DB      0E9h            ; jmp EFAh
NewJmpAddr      DW      0000h
NewCode_End     label   byte

Div0Code         label   byte
        pop     ax
        inc     ax
        inc     ax
        push    ax
        push    cx
        mov     cx,3
@@:
        push    cx
        mov     al,06h
        out     37h,al
        mov     cx,2222h
        loop    $
        mov     al,07h
        out     37h,al
        mov     cx,5555h
        loop    $
        pop     cx
       loop     @b
        pop     cx
        mov     dx,0000h
        mov     ax,0FFFEh
        iret    
Div0Code_End     label   byte
;----------------------------------------

stack_base      label   byte    ; The limit of stack
code    ends
        end     start
END
