;========================================================
.386p
;jmp     start_program
SELECTOR_NULL           equ     0000h
SELECTOR_P_MODE_FF8000  equ     0008h
SELECTOR_REAL_MODE      equ     0010h
SELECTOR_P_STACK        equ     0018h

GDT_t   STRUC
_limit       dw ?
_base0       dw ?
_base16      db ?
_accb        db ?
_flags       db ?
_base24      db ?
GDT_t   ENDS

;------------------------------------------------------------------
;       GoPmode 
;------------------------------------------------------------------
                PUBLIC  GoPmode
GoPmode         PROC    near
                mov     al,02h  ; A20}XN
                out     0F6h,al
                xor     eax,eax
                mov     edx,eax
                mov     dx,offset cs:GDT00
                mov     ax,cs
                mov     cs:cs_real,ax
                shl     eax,4
                mov     cs:GDT10._base0,ax
                ror     eax,16
                mov     cs:GDT10._base16,al
                rol     eax,16
                add     eax,edx
                mov     dword ptr cs:GDTB,eax
                LGDT    cs:GDTR
                cli     
                mov     eax,CR0
                or      eax,00000000000000000000000000000001b
                mov     CR0,eax
                DB      0EAh    ; JMP far 
                DW      offset ProtectModeEnt
                DW      SELECTOR_REAL_MODE
ProtectModeEnt: 

                mov     dx,SELECTOR_P_MODE_FF8000
                mov     GS,dx

;ReturnToRealMode:
                mov     eax,CR0
                and     al,0FEh
                mov     CR0,eax
                DB      0EAh    ; JMP far (use16)
                DW      offset RealModeEnt
cs_real         DW      0
RealModeEnt:    
                jmp  $+2        ; clear CPU  internal pipe line
                jmp  $+2
                sti
                ret
GoPmode         ENDP

align 8
GDTR            label   fword
GDTL            DW      24-1
GDTB            DD      0
                DW      0
GDT00           GDT_t   < 0000h, 0000h, 00h, 00000000b, 00h, 00h > ; null selector
GDT08           GDT_t   <0FFFFh, 8000h,0FFh, 10010011b, 8Fh,0FFh > ; Prot. mode
GDT10           GDT_t   <0FFFFh, 0000h, 00h, 10011011b, 00h, 00h > ; real mode
GDT18           GDT_t   <0FFFFh, 0000h, 00h, 10010111b, 8Fh, 00h > ; Prot. stack
;                      limit0-15 base0  b16   DPL RW    flg b24
;                         0,1    2,3     4        5      6   7
;                              (--24bit--)(12) (32bit) limH20
.186