TTL equ "PC-9800 series BIOS/ITF ROM ǏovO V3.26  Copyright(C) 2023-25 ܂"
;USE15M  equ 1
code            segment
                assume cs:code, ds:code, es:code, ss:code
                org 0100h
start:          JMP     StartGetITFP
msg_ttl         DB      0E1h,TTL,13,10,0
msg_pmode       DB      041h," z86[hł͎sł܂. EMM386Ȃǂ̂ȂŎsĂ.",13,10,0
IFDEF USE15M  
msg_inf15MB     DB      0E1h," 15-16MBVXeԂ̏Ԃsł. ugpv̂ƂĎs܂.",13,10,0
msg_wrong15MB   DB      041h," uVXeZbgAbvj[vŁu16MBVXeԁvugpv"
                DB      "ݒɂĂċNAsĂ.",13,10,0
ENDIF
msg_a20msked    DB      0E1h," A20ײ݂ϽԂł.  ",0
msg_wrongCPU    DB      041h," V30,8086ڋ@ɂITFpROM͂܂.",13,10,0
msg_space1      DB      0E1h," ",0
msg_CRLF        DB      0E1h,13,10,0
msg_bar1        DB      0A1h,86h,0A2h,0
msg_end         DB      0E1h,"I܂.",13,10,0
msg_a20         DB      0E1h," A20ײ݂ϽԂɖ߂܂.",13,10,0

.286
STACK_SIZE      equ     256     ; stack byte size
ROM_BANK_SIZE   equ     8000h   ; ROM BANK̃f[^TCY32KBŒ
BANK_MAX        equ     8       ; őoN͒ʏ 8 Œl
; tOrbg`
F_80286M        equ     01h     ; 4Ggp4oNo͂Ȃ[h̃tO
F_21NOTE        equ     02h     ; 9821 NOTE@tO
;F_REDWOOD       equ     02h     ; REDWOODtOigpj,ȉF8E8:0004h蓾
F_PCIBUS        equ     04h     ; PCIoX݃tO
F_SYSCLK8M      equ     08h     ; SYSTEM COLOCK 8/10 MHztO
F_HIRESO        equ     10h     ; nC][htO
F_A20MASK       equ     20h     ; 1=A20̓}XN(disable) 0=A20 enable
F_40pin         equ     40h     ; 40pin ROMgptO,@ID̒m瓾
F_SYS15M        equ     80h     ; 15-16MBԂVXeŎgp̃tO

align 2
Seg9821         DW      0F8E8h
Seg0000         DW      0000h   ; ZOgO
BufferAddr      label   dword   ; DOStDWORDAhX
BufferOfs       DW      0000h   ; K[
BufferSeg       DW      7000h   ; f[^obt@̃ZOg
WordSum         DW      0000h   ; [hTl l0
BankSumPtr      DW      offset BankSumArray     ; V2.30ǉ
BankSumArray    DW      0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0 ; eoNwordTlL
;ROW             DW      0       ; sʒuigpĂȂj
;COLUMN          DW      0       ; JʒuigpĂȂj
COLOR_ATTRIB    DB      0E1h    ; text color attribute
flagset         DB      0       ; 낢bittO
CPUtype         DB      3       ; CPŨ^Cv 0..6 ܂
Bank4MHL        DB      0       ; 2MoNʉ low=0, high=1
Bank4MLoop      DB      1       ; JԂ̉ 4Mbit=2,  2Mbit=1 ; V3.26ǉ
BankNum         DB      0       ; ݂̃oNԍ 0..7

.8086
StartGetITFP:
                mov     bx,offset stack_top
                add     bx,STACK_SIZE
                mov     cl,4
                shr     bx,cl   ; paragraph sizeɕϊ /16
                inc     bx
                mov     sp,bx
                mov     ah,4Ah  ; truncate
                int 21h
                call    DisplayTitle
                call    MemAlloc32K      ; 32KBm
                jc      ExitProcess
                call    CheckA20Phys    ; A20C̃}XNԂ𓾂Ă
                jnz     @f
                mov     dx,offset msg_a20msked
                call    _puts
                or      flagset,F_A20MASK   ; tOA20MaskLĂ
        @@:

                call    CheckParam      ; R}hC̎擾 /4 -4
                test    flagset,F_80286M
                jz      StartGetITF32
                mov     dx,offset msg_80286
                call    _puts
                call    CheckNative286
                jnz     @f
                mov     dx,offset msg_wrongCPU
                call    _puts           ; ΉȂCPUłƂ\
                call    ShortBeep
                jmp     ExitProcess
        @@:
                call    Getitf286       ; A[h4oN̏o͂s
                jc      ExitProcess
                jmp     Success

StartGetITF32:
                call    CheckCPU386     ; CPU 386ȏォǂ
                jnc     @f
                mov     dx,offset msg_wrongCPU
                call    _puts           ; ΉȂCPUłƂ\
                call    ShortBeep
                jmp     ExitProcess
        @@:
                call    PrintCPUtype
                call    CheckEPSON      ; Gv\@ł̎s
                jc      ExitProcess
                

                call    CheckMachineEnv ; @`FbN
                jc      ExitProcess     ; io[Wł̓G[^[͖j
                call    Detect_28F400
IFDEF USE15M  
                call    CheckUsing15MB  ; 15-16MBVXeԂ̏ԃ`FbN
                test    flagset,F_SYS15M
                jz      @f
                mov     dx,offset msg_wrong15MB
                call    _puts
                call    ShortBeep
                jmp     ExitProcess
        @@:
ENDIF
                call    GoPmode
                call    MAIN2
                jc      ExitProcess
Success:
                mov     dx,offset msg_end
                call    _puts
;;              call    CaptureD000     ; PC34RAMɉʃLv`
ExitProcess:    
                test    flagset,F_A20MASK    ; LĂA20 masktO
                jz      @f              ; [ȂpX,1Ȃ}XNs
                mov     al,3    ; A20C}XN
                out     0F6h,al 
                mov     dx,offset msg_a20
                call    _puts
        @@:
                mov     ah,4Ch
                int 21h         ; IDOSɖ߂
                RET

;-------------------------------------------
;       MAIN2
;-------------------------------------------
MAIN2           PROC   near
                mov     Bank4MHL,0
Bank4MHL_ent:   
                mov     BankNum,0       ; ROM bankԍݒ, 0..7
BankSelEnt:     
                cli     ; ֎~iKvȂƂ̌_Ô߁j
                call    go_ITFmode      ; ITFɐ؂ւ
                call    Copy_F800_buf   ; 4GԂROMBufferփRs[
                call    go_BIOSmode     ; BIOSɖ߂
                sti     ; ֎~

                xor     ax,ax
                call    CheckEqual32K   ; ׂ0000hH
                jnz      @f
                call    ShortBeep       ; ł΃r[v
        @@:
                
                mov     ax,0FFFFh
                call    CheckEqual32K   ; ׂFFFFhH
                jnz      @f
                call    ShortBeep       ; ł΃r[v
        @@:
        
                mov     cl,BankNum      ; ݂̃oNԍCLɓ
                call    SaveToFile      ; t@Cۑ[`(DOS)
                jc      EndOfSaveFile
                mov     dx,offset msg_space1
                call    _puts
                mov     dx,offset BankName
                call    _puts
                call    CheckSumWord
EndOfSaveFile:
                inc     BankNum         ; oNԍPi߂
                
                cmp     BankNum,BANK_MAX ; oNԍ ő ܂ŗI
                jb      BankSelEnt      ; oNIɖ߂JԂ

                inc     Bank4MHL        ; oNZbgʁʂɐi߂
                mov     al,Bank4MHL     ; 
                cmp     al,Bank4MLoop   ; oNZbgői1 or 2jǂ
                jb      Bank4MHL_ent    ; oNZbgԍ ő喢ȂJԂ

Completed:      
                test    flagset,F_21NOTE        ; m[g@tO
                jz      EndNoteSum
NoteCalcSum:    ; 9821m[g@ł̓oN00-03ʂăT00hł邱Ƃ\
                mov     bx,offset BankSumArray
                mov     dx,0
                mov     cx,4
loop4:
                mov     ax,word ptr [bx]
                add     dl,al
                add     dh,ah   ; `FbNTDH:DL
                inc     bx
                inc     bx
                dec     cx
                or      cx,cx
                jnz     loop4
                mov     WordSum,dx
                call    DisplayNoteSum
                mov     COLOR_ATTRIB,081h
                mov     dx,offset msg_CRLF
                call    _puts
EndNoteSum:
                test    flagset,F_40pin ; A-mate,B- Ȃǂ̐ɋ@킩
                jz      EndSum
ROM40_calcSum:  ; oN0102̃T00ȂOK̋@ ł͂\
                mov     bx,offset BankSumArray
                mov     dx,0
                mov     ax,[bx+0]       ; BANK 0
                add     dl,al
                add     dh,ah
                mov     ax,[bx+2]       ; BANK 1
                add     dl,al
                add     dh,ah
                mov     ax,[bx+4]       ; BANK 2
                add     dl,al
                add     dh,ah
                mov     ax,[bx+6]       ; BANK 3
                add     dl,al
                add     dh,ah
                mov     WordSum,dx
                call    Display40pinSum
                mov     COLOR_ATTRIB,0A1h
                mov     dx,offset msg_CRLF
                call    _puts
EndSum:
                RET
MAIN2           ENDP

;---------------------------------------------------------------
go_ITFmode      PROC    near
                call    FlushCache
                mov     dx,043Fh ;      ITF BANK select
                mov     al,BankNum
                shl     al,1
                or      al,0E0h ;       convert to I/O adrress value
                out     dx,al

                mov     dx,043Dh ;      ITF mode
                mov     al,10h   ; Normal mode=10h,hireso=00h $$$
                test    flagset,F_HIRESO
                jz      @f
                mov     al,00h
        @@:     
                out     dx,al
                out     5Fh,al

                cmp     BANK4MHL,1
                jnz     BANK4M_HI
                mov     dx,0B00h        ; I/O 0B00h V@\WX^|[g
                mov     ax,00F0h        ; Command register F0h: A18 line select
                out     dx,ax           
                mov     dx,0B02h        ; I/O 0B02h Data register
                xor     al,al           ; 0= Lower 2Mbit (extended 2Mbit)
                out     dx,al
BANK4M_HI:      call    FlushCache
                ret
go_ITFmode      ENDP
;---------------------------------------------------------------
go_BIOSmode     PROC    near
                call    FlushCache
                mov     dx,043Fh        ; ITF BANK select
                mov     al,0E8h         ; to BANK4
                out     dx,al
                mov     dx,043Dh        ; to BIOS mode
                mov     al,2
                out     dx,al

                cmp     BANK4MHL,1
                jnz     BANK4M_HI_e
                mov     dx,0B00h        ; I/O 0B00h V@\WX^|[g
                mov     ax,00F0h        ; Command register F0h: A18 line select
                out     dx,ax
                mov     dx,0B02h        ;  I/O 0B02h Data register
                mov     al,1            ; 0= higher 2Mbit (ordinary 2Mbit)
                out     dx,al
BANK4M_HI_e:    call    FlushCache
                ret
go_BIOSmode     ENDP
;-----------------------------------------------------------------------
Detect_28F400   PROC    near
                push    ds
                mov     ds,Seg9821
                mov     al,ds:[003Fh]
                pop     ds
                cmp     al,29h  ; Excluding Machine ID Xe10,BX4,V7-13,Xa7e
                je      ThisROMisNot4M
                cmp     al,2Ah
                je      ThisROMisNot4M
                cmp     al,2Dh
                je      ThisROMisNot4M
                cmp     al,2Eh
                je      ThisROMisNot4M
                ; Rv,RvII,Rs,RsII, PCI Canbe
                mov     dx,0B00h        ; I/O 0B00h V@\WX^|[g
                mov     ax,0F0h         ; Command register F0h=A18 line select
                out     dx,al
                mov     dx,0B02h        ; I/O 0B02h Data register
                in      al,dx           ; AL=7F 4M bit /  AL=FF not
                cmp     al,0FFh
                je      ThisROMisNot4M  ; 2022-4-20
                mov     Bank4MLoop,2    ; 4Mbit
ThisROMisNot4M: 
                ret
Detect_28F400   ENDP

;---------------------------------------------------------------
;       CheckSumWord
;---------------------------------------------------------------
CheckSumWord    PROC   near
                call    CalcSum_ROM     ; ̃`FbNT̒lvZ
                mov     WordSum, DX     ; DXɕԂĂ̂ŕۑ
                call    DisplayCheckSum ; \
                mov     dx,offset msg_CRLF
                call    _puts
                ret
CheckSumWord    ENDP

;---------------------------------------------------------------
;       DisplayCheckSum
;---------------------------------------------------------------
DisplayCheckSum PROC    near
                mov     dx,offset msg_sum0
                call    _puts
                xor     ax,ax
                mov     al,BANK4MHL
                shl     al,1
                shl     al,1
                shl     al,1    ; = SHL AL,3
                add     al,BankNum
                mov     cx,2
                call    digitx2
DisplayCheckSumEntry2:
                mov     dx,offset msg_sum1
                call    _puts
                mov     ax,WordSum
                mov     ah,00h

                call    digitx2
                mov     dx,offset msg_sum2
                call    _puts
                mov     ax,WordSum
                xchg    al,ah
                mov     ah,00h

                call    digitx2
                mov     dx,offset msg_sumEnd
                call    _puts
                ret
msg_sum0   db   0E1h,"  Result:  Bank number[",0
msg_sum1   db   0E1h,"]  even SUM =[",0
msg_sum2   db   0E1h,"]   odd SUM =[",0
msg_sumEnd db   0E1h,"] .",0
DisplayCheckSum ENDP
;---------------------------------------------------------------
DisplayNoteSum  PROC   near
                mov     COLOR_ATTRIB,061h
                mov     dx,offset msg_sumN0
                call    _puts
                mov     dx,offset msg_sumN1
                call    _puts
                jmp     DisplayCheckSumEntry2
                ret
msg_sumN0  db   0E5h," Note type SUM ",0
msg_sumN1  db   0E1h," Bank [0-3",0
DisplayNoteSum  ENDP
;---------------------------------------------------------------
Display40pinSum PROC   near
                mov     COLOR_ATTRIB,081h
                mov     dx,offset msg_sum40
                call    _puts
                mov     dx,offset msg_sum41
                call    _puts
                jmp     DisplayCheckSumEntry2
                ret
msg_sum40  db   0C1h," ʎZ00ȂOK",0
;msg_sum40  db   0E1h," MaskROM 40pin ",0
msg_sum41  db   0E1h," Bank [0-3",0
Display40pinSum ENDP

;---------------------------------------------------------------
;       CalcSum_ROM     using AX,CX,DX,DI,ES
;---------------------------------------------------------------
CalcSum_ROM     PROC    near
                push    es
                les     di,BufferAddr
                mov     cx,4000h ; 4000h-1
                xor     dx,dx
CalcSum_ent:    mov     ax,es:[di]
                add     di,2
                add     DL,AL
                add     DH,AH
               loop     CalcSum_ent
                mov     ax,es:[di]
                pop     es
                mov     bx,BankSumPtr   ; eoNTž݂̃|C^
                mov     [bx],dx         ; ɍ̃TL
                add     BankSumPtr,2    ; |C^̐i߂Ă
                ret
CalcSum_ROM     ENDP


;--------------------------------------------------------
;       DisplayTitle    
;--------------------------------------------------------
DisplayTitle    PROC   near
                mov     dx,offset tcls
                mov     cx,6
                mov     bx,2
                mov     ah,40h
                int 21h
                mov     dx,offset msg_ttl
                call    _puts
                mov     cx,40
                mov     dx,offset msg_bar1
       @@:      call    _puts
               loop     @b
;                mov     dx,offset msg_CRLF
;                call    _puts
                ret
tcls            DB      1Bh,"[2J",13,10
DisplayTitle    ENDP

.386
;--------------------------------------------------------
;   Copy_F800_buf   F800:0 --> Buffer ɃRs[ 
;--------------------------------------------------------
Copy_F800_buf   PROC   near
;;;             mov     gs,0F800h
                mov     si,0000h
                les     di,BufferAddr
                mov     cx,ROM_BANK_SIZE/2      ;32KB
        @@:
                mov     ax,gs:[si]
                inc     si
                inc     si
                stosw
               loop     @b
                ret
Copy_F800_buf   ENDP
.286

IFDEF USE15M  
;--------------------------------------------------------
;       CheckUsing15MB
;--------------------------------------------------------
CheckUsing15MB  PROC   near
                mov     dx,8F1Eh
                in      al,dx
                cmp     al,0FFh
                je      Check43B
                test    al,1
                jz      @f
                or      flagset,F_SYS15M
        @@:
                clc
                ret
Check43B:
                mov     dx,043Bh
                in      al,dx
                cmp     al,0FFh
                je      No043B
                and     al,4
                cmp     al,4
                je      @f
                or      flagset,F_SYS15M
        @@:
                clc
                ret
No043B:         
UnknownU15:     or      flagset,F_SYS15M
                mov     dx,offset msg_inf15MB
                call    _puts
                call    ShortBeep
                stc
                ret
CheckUsing15MB  ENDP
ENDIF

;-------------------------------------------------------------
;  CheckEqual32K    AX=val TEST̈̑SĂvalǂׂ
;-------------------------------------------------------------
CheckEqual32K   PROC   near
                push    es
                mov     dx,ax
                les     di,BufferAddr
                mov     cx,ROM_BANK_SIZE/2
        @@:     
                mov     ax,es:[di]
                cmp     ax,dx
                jne     MEM_NOT_EQ_EDX
                add     di,2
               loop     @b
MEM_NOT_EQ_EDX:   
                or      cx,cx   ; Ō܂œBĂ邩
                pop     es
                ret
CheckEqual32K   ENDP

;--------------------------------------------------------
FlushCache      PROC   near
                push    dx
                mov     dx,043Fh
                mov     al,0A0h ; LbṼtbV Xe10/BX4̂悤
                out     dx,al   ; BIOS̈悪LbV@ł͐ΕKv
                pop     dx
                ret
FlushCache      ENDP

;----------------------------------------------------------------------
CheckNative286  PROC   near
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     al,ds:[0480h]
                pop     ds
                mov     ah,al
                and     al,00000011b
                or      al,al   ; 0=V30,8086 , 1=80286, 3=80386
                ret
CheckNative286  ENDP

;----------------------------------------------------------------------
                PUBLIC  _digit
_digit          PROC    NEAR
                push    es
                push    si
                push    bx
                push    ds
                pop     es
                push    ax
                cmp     cx,0FFFFh
                je      Noalign
                xor     dx,dx
                mov     ax,128
                div     _digit_div
                cmp     cx,ax
                jbe     cx_ok1
                mov     cx,ax
cx_ok1:         
                cmp     cx,1
                jae     cx_ok2
                mov     cx,ax
cx_ok2:         
Noalign:        
                std
                 mov     di,offset ds:_convert$end
                 xor     bx,bx
                 mov     bx,ds:_digit_div
                 mov    al,0
                 stosb   
                pop     ax  ;   ax=value
                xor     dx,dx
_digit_ent:     
                div     bx
                mov     si,offset ds:_hextbl
                add     si,dx
                movsb
                dec     cx
                xor     dx,dx
                or      ax,ax
                jnz     _digit_ent
_digit_end:     
                cmp     cx,33   ; 33
                jae     digit_err
                or      cx,cx
                jz      digit_err
                mov     al,_digit_zsup
digit_spc_loop: stosb
               loop     digit_spc_loop
digit_err:      mov     al,COLOR_ATTRIB
                stosb
                cld
                inc     di
                mov     dx,di
                pop     bx
                pop     si
                pop     es
                ret
_digit          ENDP

;--------------------------------------------------------------------

_digit_div      DW      10
_digit_zsup     DB      ' '
_hextbl         DB      "0123456789ABCDEF"
$KetaBuf17      DB      "                 "
_convert$end    DB      0

;----------------------------------------------
;       digitx2
;----------------------------------------------
digitx2         PROC    near
                mov     COLOR_ATTRIB,0A1h
                pusha
                mov     ah,0
                mov     cx,2
                mov     _digit_zsup,'0'
                mov     _digit_div,16
                call    _digit
                call    _puts
                popa
                ret
digitx2         ENDP


.8086

;-------------------------------
;       CheckShadowRAM
;-------------------------------
CheckShadowRAM  PROC   near
                mov     ax,8000h
                mov     es,ax
                mov     dx,0461h
                mov     al,0Ch
                mov     ax,es:[0]
                mov     bx,0AA55h
                ret
CheckShadowRAM  ENDP
;-------------------------------
waits           PROC   near
                push    cx
                mov     cx,0EDCBh
        @@:     out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
               loop     @b
                pop     cx
                ret
waits           ENDP
;----------------------------------------------------------------------
ShortBeep       PROC   near
                test    flagset,F_SYSCLK8M
                jz      @f
                mov     BeepFreqCount,983
        @@:
                test    flagset,F_HIRESO
                jz      @f
                mov     BeepIOAddr,0077h
        @@:
                mov     ax,5432
                push    ax
                push    dx
                push    cx
                mov     dx,BeepIOAddr   ; 3FDB
                out     dx,al
                xchg    al,ah
                out     dx,al
                mov     al,6    ; beep
                out     37h,al

                mov     cx,2222h       ; 
        @@:
                out     5Fh,al
                out     5Fh,al
        loop    @b

                mov     al,7    ; beep off
                out     37h,al
                mov     cx,0EDCBh       ; 
        @@:
                out     5Fh,al
                out     5Fh,al
        loop    @b
                mov     ax,BeepFreqCount        ; original beep freq.
                mov     dx,BeepIOAddr
                out     dx,al
                xchg    al,ah
                out     dx,al
                pop     cx
                pop     dx
                pop     ax
                ret
BeepFreqCount   DW      1229h
BeepIOAddr      DW      3FDBh
ShortBeep       ENDP


;--------------------------------------------------------------------
;       CheckCPU386     ȈՂCPU386        NC=386, CY below 386
;--------------------------------------------------------------------
CheckCPU386     PROC   near;  ϐ CPUtype  x=0..6
                pushf
                pop     ax
                pushf
                or      ax,4000h
                push    ax
                popf
                pushf
                pop     ax
                popf
                and     ax,0C000h
                cmp     ax,4000h
                jNe     Not386
                mov     ax,0300h
                mov     CPUtype,AH
                mov     es,Seg0000
                mov     ax,es:[0486h]
                cmp     ah,4
                jb      @f
                and     ah,0Fh
                mov     CPUtype,ah
        @@:     clc
                ret
Not386: 
                pushf
                pop     ax
                test    ax,8000h
                jnz     Not286
                mov     ax,0200h
                mov     CPUtype,ah
                or      flagset,F_80286M
                stc
                ret
Not286:         mov     ax,0100h
                DB      0D5h,00h        ; AAD 00(V30)    AAD(intel)
                jz      NotV30          ; AL=0          AL=0Ah
                mov     ax,0100h        ; V30 ̒l 0100h Ƃ
                mov     CPUtype,ah
NotV30:         
                call    ShortBeep
                stc
                ret
CheckCPU386     ENDP


;---------------------------------------------------------------
;       CheckEPSON      (Inspect EPSON ID)
;---------------------------------------------------------------
CheckEPSON      PROC   near
                xor     ax,ax
                mov     es,ax
                mov     ax,0FD80h       ; seg
                mov     bx,0002h        ; ofs
                mov     cx,2A27h        ; EPSON 27h,2Ah (Normal)
                test    byte ptr es:[0501h],8
                jz      EpsonNormalMode
                mov     ax,0F800h       ; seg
                mov     bx,07F70h       ; ofs
                mov     cx,1827h        ; EPSON 27h,18h (Hireso)
EpsonNormalMode:  
                mov     es,ax
                cmp     es:[bx],cx      ; compare
                je      IsEPSONPC
                clc
                ret
IsEPSONPC:      
                mov     al,es:[3]
                mov     ah,0
                call    ShortBeep
                mov     dx,offset msg_EPSONPC
                stc     ; CY=EPSON PC
                ret
msg_EPSONPC     DB 041h,"EPSON PCV[Ył͎sł܂.",13,10,0
CheckEPSON      ENDP


;---------------------------------------------------------------
;       MemAlloc32K
;---------------------------------------------------------------
MemAlloc32K     PROC    near
                mov     bx,ROM_BANK_SIZE/8     ; 16=paragraph size
                inc     bx
                mov     ax,4800h
                int     21h
                jc      mem_err
                mov     BufferSeg,ax
                mov     es,ax
                xor     ax,ax
                mov     di,ax
                mov     BufferOfs,ax
                mov     cx,ROM_BANK_SIZE/2
                mov     ax,0FFFFh
            rep stosw
                clc
                ret
mem_err:        mov     dx,offset msg_mAllocFail2
                call    _puts
                call    ShortBeep
                stc
                ret
msg_mAllocFail2 DB      061h,"DOS̋󂫃sĂ܂.",13,10,0
MemAlloc32K     ENDP

;---------------------------------------------------------------------------

;---------------------------------------------------------------
;       SaveToFile      banknum
;---------------------------------------------------------------
SaveToFile      PROC    near
                mov     bx, offset hexadecimal_tbl
                mov     al,Bank4MHL
                shl     al,1
                shl     al,1
                shl     al,1
                add     al,BankNum
                xlat
                mov     bx, offset OutputFileName
                mov     [bx+4],al
; file create
                mov     dx, bx
                mov     cx, 0020h
                mov     ax,3C00h
                xor     bx,bx
                int     21h
                jc      creat_err
                mov     DOS_handle,ax
; file write
                mov     bx,DOS_handle
                mov     cx,ROM_BANK_SIZE
                
                push    ds
                lds     dx,BufferAddr
                mov     ax,4000h
                int 21h
                pop     ds
                
                jc      write_err
                cmp     ax,ROM_BANK_SIZE
                jnz     write_err
                mov     bx,DOS_handle
                mov     ah,3Eh  ; close file 
                xor     dx,dx   
                int     21h     
                clc
                ret
creat_err:      mov     dx,offset CreatErrMsg
                jmp     SaveFail
write_err:      mov     dx,offset WriteErrMsg
                jmp     SaveFail
data_err:       mov     dx,offset DataErrMsg
                jmp     SaveFail
SaveFail:       call    _puts
                stc
                ret
align 2
DOS_handle      DW  -1
hexadecimal_tbl DB "0123456789ABCDEF"
BankName        DB 0E1h
OutputFileName  DB "BANK4.BIN",0
CreatErrMsg     DB 041h,"t@C쐬G[",13,10,0
WriteErrMsg     DB 061h,"t@CG[",13,10,0
DataErrMsg      DB 041h,"f[^G[",13,10,0
SaveToFile      ENDP

;---------------------------------------------------------------------------
;       CheckParam
;---------------------------------------------------------------------------
CheckParam      PROC   near
                mov     ah,62h
                int     21h
                mov     es,bx
                mov     bx,80h
                mov     al,es:[bx]
                inc     bx
                or      al,al
                jnz     @f
                stc
                ret
        @@:     mov     cl,al
                mov     ch,0
ParamLoopEnt:   mov     al,es:[bx]
                inc     bx
                cmp     al,'-'
                je      EndParam
                cmp     al,'/'
                je      EndParam
        @@:     
               loop     ParamLoopEnt
                stc
                ret
EndParam:       mov     al,es:[bx]
                cmp     al,'4'
                jne     @b
                or      flagset,F_80286M
                clc
                ret
CheckParam      ENDP
;-----------------------------------------------
;       PrintCPUtype
;-----------------------------------------------
PrintCPUtype    PROC   near
                mov     dx,offset CPU_is
                call    _puts
                mov     bl,CPUtype
                mov     bh,0
                shl     bx,1
                mov     si,offset CPU_mes_p
                mov     dx,[si+bx]
                call    _puts
                ret
CPU_is      DB  0E1h,"CPU : ",0
CPU_mes_p   DW  offset CPU086, offset CPU186, offset CPU286, offset CPU386, offset CPU486, offset CPU586, offset CPU686
CPU686      DB  0E1h,"uP6̧ ۾v",13,10,0
CPU586      DB  0E1h,"Pentium ܂͂̏ʌ݊i",13,10,0
CPU486      DB  0E1h,"i486 ܂͂̌݊i",13,10,0
CPU386      DB  0E1h,"80386",13,10,0
CPU286      DB  0E1h,"80286",13,10,0
CPU186      DB  061h,"NEC V30",13,10,0         ; ΂ɑΉȂ@
CPU086      DB  041h,"i8086",13,10,0 ; ΂ɑΉȂ@
PrintCPUtype    ENDP

.186
;---------------------------------------------------------------
;       Check9821_3F    AL= machine ID
;---------------------------------------------------------------
Check9821_3F    PROC   near
                mov     cx,offset DATA_exclude - offset DATA_40pin
                mov     si,offset DATA_40pin
        @@:     cmp     al,byte ptr [si]
                je      Found40pin
                inc     si
               loop     @b
                clc
                ret
Found40pin:     or      flagset,F_40pin
                mov     dx,offset msg_40pin
                call    _puts
                mov     dx,offset msg_CRLF
                call    _puts
                stc
                ret
DATA_40pin      DB      00h,01h,02h,05h,06h,07h,08h,09h,0Dh, 0Bh,18h
                ;       Ap ,?? ,Ce ,Af ,Ap2,B2 ,Ce2, Ts, An, Bf, Ap3
                DB      80h,81h,82h,83h,84h
                ; hires Ap, Af, Ap2, An,Ap3
DATA_exclude    DB      17h
                ;       Cf
msg_40pin       DB      0E1h," iBANK 0-3ʎZSUM 0DESKTOP@j",0
Check9821_3F    ENDP

.286
;---------------------------------------------------------------
;       CheckMachineEnv
;---------------------------------------------------------------
CheckMachineEnv PROC    near
                mov     dx,offset msg_CheckEnv
                mov     cx,24
                mov     bx,2
                mov     ah,40h
                int     21h
                call    waits
                smsw    ax
                test    al,1
                jz      @f
                mov     dx,offset msg_pmode
                call    _puts
                call    ShortBeep
                stc
                ret
        @@:
                xor     ax,ax   ; 2003-7-10 2.03h  A-mate nC][h
                mov     es,ax   ; ւ̑Ήǉ
                mov     al,es:[0501h]
                test    al,80h
                jz      @f
                or      flagset,F_SYSCLK8M
        @@:
                test    al,8
                mov     dl,0
                mov     ax,0F8E8h       ; 9821`FbNsegmentm[}
                jz      non_hireso
                or      flagset,F_HIRESO
                mov     dl,80h
                mov     ax,0FFE8h       ; 9821`FbNsegmentnC]
non_hireso:     mov     es,ax
                mov     Seg9821,ax
                mov     ax,es:[0000h]
                cmp     ax,2198h       ; 9821`FbN
                jnz     Not9821
                mov     al, es:[0004h]
                test    al,00100000b   ; bit5 PCIbus ڃtO`FbN
                jz      @f
                or      flagset,F_PCIBUS
        @@:
                test    al,00000010b   ; bit1 RED WOOD ڃtO`FbN
                jz      @f
;               or      flagset,F_REDWOOD
        @@:
                mov     al,es:[003Fh]
                or      al,dl   ; dl=80h/00h
                call    Check9821_3F;   A-mate@`FbN 2023-7-25 2.30
                mov     al,es:[0003h]
                test    al,01001000b    ; m[g@`FbN 2003-7-10 2.03h
                jz      NotNoteMachine
                or      flagset,F_21NOTE
NotNoteMachine: clc
                ret
Not9821:        ;call    CheckShadowRAM
                clc
                ret
msg_CheckEnv    DB      "}V`FbN...",13,0
CheckMachineEnv ENDP

;==========================================
include   for286.s
;==========================================
include dosputs.s
include pmodeff8.s

;ȍ~Ƀf[^uĂ͂ȂȂ
stack_top       label byte
code    ends
        end start

END
