.186
;---------------------------------------------------------------------------
;    DIV0ROM.S  C-BUS boot ROM loader (C) 2002 ܂(DOSsoft) Version 1.10
;---------------------------------------------------------------------------

code            segment
                assume cs:code,ds:code,es:code,ss:code
                org    0
start:          DB      0CBh, 90h, 90h
                DB      0CBh, 90h, 90h
                DB      0CBh, 90h, 90h  ;                 ** bx bx+1
                DB       55h,0AAh, 0Dh  ; C BUS ROM ID =  0D,CD,8D
                org  0Ch                ;          of this board
                JMP     ROM_entry1
                nop
                org  0Fh
                DB      0CBh, 90h, 90h, 0CBh, 90h, 90h
                DB      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h
                DB      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h
                DB      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h

ROM_entry1:     mov     byte ptr ds:[bx],0CDh  ; 0CDh ; ROM pruducts and type
                pushf
                push    ax
                push    es

                xor     ax,ax
                mov     es,ax
                
                pushf
                cli
                mov     ax,offset div0recover
                mov     es:[0],ax
                mov     ax,cs
                mov     es:[2],ax
                popf

                pop     es
                pop     ax
                popf
                RETF
                
                DW      0
align 2
div0recover:    
               push     ax
               push     bx
               push     cx
               push     dx
               push     si
               push     di
               push     es

                call    CheckDX         ; Set Text Color Attributes
                mov     si,offset div0mes
                mov     cx,offset div0mes_e - offset div0mes
                call    DisplayVRAM
                call    Beepwait
                
               pop      es
               pop      di
               pop      si
               pop      dx
               pop      cx
               pop      bx
               pop      ax

                pop     ax      ; retrive previous stack
                inc     ax      ; 2 byte before the called addresss 
                inc     ax
                push    ax      ; store the adress to stack memory
                mov     dx,0            ; return value of DX:AX is set to
                mov     ax,0FFFEh       ; maximum of 16bit -1 
                iret            ; resume instruction

                DW      0

Beepwait        PROC   near
                mov     cx,0F00h
                mov     al,06h
                out     37h,al
                call    WaitLoop
                mov     al,07h
                out     37h,al
                mov     cx,4000h
                call    WaitLoop
                ret
Beepwait        ENDP

WaitLoop        PROC   near
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
               loop     WaitLoop
                ret
WaitLoop        ENDP

CheckDX         PROC   near     ; DX=00FBh
                mov     bx,sp           ; [sp+18]= segment of called addr
                mov     dx,ss:[bx+18]   ; same as ss:[sp+18]
                cmp     dx,0DC00h
                jz      Cyn
                cmp     dx,0D000h
                jz      Cyn
                cmp     dx,0D800h
                jz      Wht
                cmp     dx,0D700h
                jz      Grn
                cmp     dx,0D600h
                jz      Cyn
                cmp     dx, 1000h
                jb      Mag
                cmp     dx, 4000h
                jb      Red
                jmp     Yel
Wht:            mov     dx,00E1h
                ret
Mag:            mov     dx,0061h
                call    BeepWait
                ret
Red:            mov     dx,0041h
                ret
Yel:            mov     dx,00C1h
                ret
Grn:            mov     dx,0081h
                ret
Cyn:            mov     dx,00A1h
                ret
CheckDX         ENDP

DisplayVRAM     PROC   near  ; cs:si=string pointer,  cx=string length, dx=iro
                cld
                shr     cx,1
                xor     ax,ax
                mov     es,ax
                mov     ah,0E0h
                mov     al,es:[0501h]
                test    al,8
                jnz     @f
                mov     ah,0A0h
        @@:     mov     al,00h
                mov     es,ax
                mov     di,(2*30) ; column location

DispVramEnt:    mov     ax,cs:[si]
                inc     si
                inc     si
                mov     es:[di+2000h],dx        ; VRAM attribute write
                stosw      
               loop     DispVramEnt
                ret
DisplayVRAM     ENDP


align 2
;;;ueʏ𒴂fBXNhCuڑĂ܂v
div0mes         label   byte
DW      462Dh,46ADh,4C2Eh,4CAEh,651Eh,659Eh,4218h,4298h,7204h,7284h,3624h
DW      36A4h,2804h,2884h,3F04h,3F84h,4705h,4785h,2305h,2385h,3905h,3985h
DW      2F05h,2F85h,4905h,4985h,6905h,6985h,2405h,2485h,5605h,5685h,2C04h
DW      2C84h,5C20h,5CA0h,3322h,33A2h,3504h,3584h,6C04h,6C84h,4604h,4684h
DW      2404h,2484h,5E04h,5E84h,3904h,3984h
div0mes_e       label   byte
DW      0000h

code    ends
        end     start

