MsgTitle        DB  13,10,"UMB̂߂ gROM̋󂫂BASIC ROM"
                DB      "mۂ. V1.10 (C) 2024 ܂",13,10,0
msg_not386      DB      "CPU80286ȉȂ̂PCIoX͍s킸,  EMJ{[h݂̑𒲂ׂ܂.",13,10,0
MsgWrongMachine DB      "̋@ł͎sł܂iPCIoXڋ@łȂ,EMJڂłȂj.",13,10,0
msg_noumb       DB      13,"UMBpshadow RAM GA̋󂫂, ɓKpς݂ł.   Ȃɂ܂.",13,10,0
MsgSize         DB      "  0 BLOCK RAMɂ܂.",13,0
msg_hireso      DB      "nC][V[h܂͂gXWV[Ył͎sł܂.",13,10,0
msg_EPSONPC     DB      "EPSON PCV[Ył͎sł܂.",13,10,0

align 4
SegmentList     label word
SegE800         DW      0E800h          ; LSB 0=OK, 1=NG
SegEC00         DW      0EC00h
SegD000         DW      0D000h
SegD400         DW      0D400h
SegD800         DW      0D800h
SegDC00         DW      0DC01h
CPUtype         DB      0
HiresoFlag      DB      0
msg_UMB_OK      DB      "UMBGA ",13,10,13,10,0
msg_space       DB      "          ",0
msg_E8          DB      " N88-BASIC E800",0
msg_EC          DB      " EC00",0
msg_D0          DB      " D000",0
msg_D4          DB      " D400",0
msg_D8          DB      " D800",0
msg_CRLF        DB      " ",13,10,0

PatternE8  DB   0EBh,22h,0EBh,29h,85h,06h,20h,01h,05h,1Bh,0FAh,0B8h,60h,00h,8Eh,0D8h
PatternEC  DB   57h,0BFh,2Ch,15h,0B9h,05h,00h,0E8h,0E2h,6Fh,5Fh,8Bh,1Eh,2Ch,15h,80h

puts    equ     putsDC
;--------------------------------------------
include   EMJSET.S
;--------------------------------------------
;-----------------------------------------------------------------------------
;   E800-D000 RAM common routine   Version 1.10  Copyright(C) 2023,24 ܂
;-----------------------------------------------------------------------------
MainStart       PROC   near
.386
                mov     dx,offset MsgTitle      ; ^Cg
                call    puts
                mov     cx,0FFF0h
        @@:     nop
               loop     @b
                call    ResoModeCheck           ; nC]тgXWO
                mov     dx,offset msg_hireso
                jc      MainAbort

                call    CheckEPSON      ; Gv\@OiȂ̂Łj
                mov     dx,offset msg_EPSONPC
                jc      MainAbort

                call    CPU386_check    ; CPŨ`FbN 386ȏł邩
                jnc     PCI_check_ent   ; łPCIoX̑݃`FbN
                mov     dx,offset msg_not386
                call    puts
                call    ExistenceCheck  ; ROM̐L^gp`FbN
                call    ROM_RAM_legacy  ; PCI@łROMRAMirj
                jmp     DispEx
PCI_check_ent:  call    PCI_Check       ; 386߂ʂPCĨ`FbN
                jc      MainAbort0      ; CYŎs
                call    ExistenceCheck  ; ROM̐L^gp`FbN
                call    ROM_RAM_PCI     ; PCI@łROMRAM
                jc      MainAbort0      ; CYŎs
DispEx:         call    DisplayAllocROM ; ROML󋵕\
                mov     al,00h
                RET     ; I
MainAbort0: ; s
                mov     dx,offset MsgWrongMachine
MainAbort:      call    puts
                mov     al,0FFh
                ret     ; I
MainStart       ENDP

;---------------------------------------
;       DisplayAllocROM
;---------------------------------------
DisplayAllocROM PROC   near
                mov     bx,0
                mov     dx,offset msg_space
                call    puts
                mov     ax,SegE800
                test    ax,1
                jnz     @f
                mov     dx,offset msg_E8
                call    puts
                call    ZeroClr
                inc     bl
        @@:     
                mov     ax,SegEC00
                test    ax,1
                jnz     @f
                mov     dx,offset msg_EC
                call    puts
                call    ZeroClr
                inc     bl
        @@:     
if 0
                mov     ax,SegD000
                test    ax,1
                jnz     @f
                mov     dx,offset msg_D0
                call    puts
                call    ZeroClr
                inc     bl
endif
        @@:     
                mov     ax,SegD400
                test    ax,1
                jnz     @f
                mov     dx,offset msg_D4
                call    puts
                call    ZeroClr
                inc     bl
        @@:     
                test    MachineType,CHIP_NOPCI
                je      @f
                mov     dx,063Ch        ; D800 bank switcher
                out     dx,al
                cmp     al,0FFh         ; without ROM bank
                je      @f
                mov     ax,SegD800      ; with bank
                test    ax,1
                jnz     @f
                mov     dx,offset msg_D8
                call    puts
                call    ZeroClr
                inc     bl
        @@:     
                mov     ax,SegDC00
                test    ax,1
                jnz     @f
                mov     dx,offset msg_D8
                call    puts
                call    ZeroClr
                inc     bl
        @@:     
                mov     al,bl
                or      al,al
                jz      UmbAreaNotFound
                mov     bx,offset MsgSize
                add     byte ptr [bx+2],al
                mov     dx,offset MsgSize
                call    puts
                
                mov     dx,offset msg_UMB_OK
                call    puts
                ret
UmbAreaNotFound:
                mov     dl,0A1h
                call    textcolor
                mov     dx,offset msg_noumb
                call    puts
                mov     dl,0E1h
                call    textcolor
                ret
DisplayAllocROM ENDP


;-------------------------------------------
;       ResoModeCheck H98ƃnC]`FbN
;-------------------------------------------
ResoModeCheck   PROC   near
                xor     ax,ax
                mov     es,ax
                mov     al,es:[0501h]
                mov     ah,es:[0458h]
                test    al,8
                jnz     ResoModeCheckFail
                test    ah,80h
                jnz     ResoModeCheckFail_H98
                clc
                ret
ResoModeCheckFail:
                or      HiresoFlag,1
ResoModeCheckFail_H98:
                stc
                ret
ResoModeCheck   ENDP

;---------------------------------------
;       ExistenceCheck
;---------------------------------------
ExistenceCheck  PROC   near
                mov     al,MachineType
                or      al,al
                jnz     IncludeE8
                or      SegE800,1
                or      SegEC00,1
                jmp     AvoidE8
IncludeE8:
                xor     ax,ax
                mov     cx,16
                mov     es,SegE800
                mov     di,ax
                mov     si,ax
                mov     si,offset PatternE8
        rep     cmpsb
                or      cx,cx
                jz      @f
                or      SegE800,1       ; not=1
        @@:
                mov     cx,16
                mov     es,SegEC00
                mov     di,ax
                mov     si,ax
                mov     si,offset PatternEC
        rep     cmpsb
                or      cx,cx
                jz      @f
                or      SegEC00,1       ; not=1
        @@:

AvoidE8:
                mov     cx,4000h/2
                mov     es,SegD000
                xor     ax,ax
                mov     di,ax
                mov     si,ax
                not     ax
        rep     scasw
                or      cx,cx
                jz      @f
                or      SegD000,1
        @@:
                mov     cx,4000h/2
                mov     es,SegD400
                xor     ax,ax
                mov     di,ax
                mov     si,ax
                not     ax
        rep     scasw
                or      cx,cx
                jz      @f
                or      SegD400,1
        @@:

                mov     cx,4000h/2
                mov     es,SegD800
                xor     ax,ax
                mov     di,ax
                mov     si,ax
                not     ax
        rep     scasw
                or      cx,cx
                jz      @f
                or      SegD800,1
        @@:
if 0
                mov     cx,1000h/2
                mov     es,SegDC00
                xor     ax,ax
                mov     di,ax
                mov     si,ax
                not     ax
        rep     scasw
                or      cx,cx
                jz      @f
                or      SegDC00,1
        @@:
endif
                ret
ExistenceCheck  ENDP

;--------------------------------------------------
;       ZeroClr  AX=SEG , SEG:0000[NA
;--------------------------------------------------
ZeroClr         PROC   near
                push    es
                push    ax
                push    cx
                push    dx
                and     ax,0FFFEh
                mov     es,ax
                xor     ax,ax
                mov     di,ax
                mov     cx,4000h/2
        rep     stosw
                pop     dx
                pop     cx
                pop     ax
                pop     es
                ret
ZeroClr         ENDP

;---------------------------------------------------------------
;       CheckEPSON
;---------------------------------------------------------------
CheckEPSON      PROC   near
                xor     ax,ax
                mov     es,ax
                mov     ax,0FD80h       ; seg
                mov     bx,0002h        ; ofs
                mov     cx,2A27h        ; EPSON 27h,2Ah (Normal)
                test    byte ptr es:[0501h],8
                jz      EpsonNormalMode
                mov     ax,0F800h       ; seg
                mov     bx,07F70h       ; ofs
                mov     cx,1827h        ; EPSON 27h,18h (Hireso)
EpsonNormalMode:  
                mov     es,ax
                cmp     es:[bx],cx      ; compare
                je      IsEPSONPC
                clc
                ret
IsEPSONPC:      
                mov     al,es:[3]
                mov     ah,0
                stc     ; CY=EPSON PC
                ret
CheckEPSON      ENDP
;--------------------------------------
;       CPU386_check    ȈՂCPU386
;--------------------------------------
CPU386_check    PROC   near
                mov     bx,0
                mov     es,bx
                mov     bx,0486h
                mov     dx,es:[bx]

                pushf
                pop     ax
                pushf
                or      ax,4000h
                push    ax
                popf
                pushf
                pop     ax
                popf
                and     ax,0C000h
                cmp     ax,4000h        
                jNe     Not386
;               or      MacEnvFlag, Bit386
                cmp     dx,0            ; if XL^2  then 0
                jne     @f              ;       else CPUID
                mov     es:[bx],0300h   ; forced 386
        @@:     mov     ax,es:[bx]
                mov     CPUtype,AH
                clc
                ret
Not386:         
                pushf
                pop     ax
                test    ax,8000h
                jnz     Not286
                mov     ax,0200h
                mov     CPUtype,ah

                mov     es:[bx],ax
                stc
                ret
Not286:         mov     ax,0100h
                DB      0D5h,00h        ; AAD 00(V30)    AAD(intel)
                jz      NotV30          ; AL=0          AL=0Ah
                mov     ax,0100h        ; V30's CPUID is set to 0100h
                mov     CPUtype,ah
                mov     es:[bx],ax      
NotV30:         
                stc
                ret
CPU386_check    ENDP
;---------------------------------------------------
if 0
BeepWait        PROC   near
                push    ax
                push    cx
                mov     al,06h
                out     37h,al
                mov     cx,8765h
        @@:     out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
                out     5Fh,al
               loop     @b
                mov     al,07h
                out     37h,al
                pop     cx
                pop     ax
                ret
BeepWait        ENDP
endif
.386
;----------------------------------------------------------------
;       PCI_Check       Ԓl CF
CHIP_NOPCI    EQU     00h   ; LEGACY (PCI chipset@ȊO)iEMJőΉj
CHIP_UNKNOWN  EQU     08h   ; NEC chipsetiΉȂj
CHIP_REDWOOD  EQU     80h   ; ڃfXNgbv@͂邩siΉȂj
CHIP_RCC      EQU     14h   ; RvII26/RsII26̂
CHIP_VLSI     EQU     02h   ; WaildCat
CHIP_Intel    EQU     01h   ; Vend=8086
CHIP_Intel_P6 EQU     11h   ; 440FX(P6 CPU)
CHIP_450KX    EQU     31h   ; intel sub, bit6=430LX, bit5=450KX, bit4=P6
CHIP_430LX    EQU     40h   ; Xf,Cf,BfiΉȂj
;----------------------------------------------------------------
PCI_Check       PROC    near
                cld
                mov     eax,80000000h   ; PCIWX^
                mov     MachineType,al  ; ϐ MachineType̓[ŏ

                mov     dx,0CF8h        ; `bvZbg WX^00
                out     dx,eax          ; 
                mov     dl,0FCh         ; 
                in      eax,dx          ; eaxœǂ
                cmp     eax,00051166h   ; x_R[h RCC/NEC chipset
                je      RCC_ChipSet     ; ȂRCC
                cmp     eax,00071004h   ; x_EfoCXVLSI_ChipSet:7
                je      VLSI_ChipSet    ; Ȃ炻 
                cmp     eax,00051004h   ; x_EfoCXVLSI_ChipSet:5
                je      VLSI_ChipSet    ; Ȃ炻 
                cmp     ax,1033h        ; x_NEC
                je      NEC_ChipSet     ; Ȃ炻 

                cmp     eax,12378086h   ; x_R[h Intel 440FX chipset
                je      IntelChipSetP6  ; Ȃintel(P6)
                cmp     ax,8086h        ; x_R[h Intel chipset
                je      IntelChipSet    ; Ȃintel

                mov     eax,8000C800h   ; Ô߃foCX25`FbN
                mov     dx,0CF8h
                out     dx,eax
                mov     dl,0FCh
                in      eax,dx
                cmp     eax,84C48086h   ; ̃x_EfoCXR[hȂ
                jz      KX450_Chipset   ; intel KX450( St20 )
; ǂɂYȂ Legacy , NEC, REDWOORD, 430LXXfΉ˂
                mov     MachineType,CHIP_NOPCI
;               jmp     PCI_Check_fail_legacy  ; ^[

PCI_Check_fail_legacy:  ; ^[(No PCI)
                mov     dx,0906h
                in      ax,dx
                cmp     ax,0FFFFh
                je      @f
                mov     MachineType,CHIP_REDWOOD
                mov     dx,offset msg_REDWOOD
                call    puts
                stc
                ret
        @@:     call    ScanBoardEMJ
                clc
                RET

RCC_ChipSet:    mov     MachineType,CHIP_RCC
                mov     dx,offset msg_RCC
                jmp     PCI_Check_OK    ; 탊^[

IntelChipSetP6: mov     MachineType,CHIP_Intel_P6 
                mov     dx,offset msg_intelP6
                jmp     PCI_Check_OK    ; 탊^[

IntelChipSet:   mov     MachineType,CHIP_Intel
                mov     dx,offset msg_intel
                jmp     PCI_Check_OK    ; 탊^[

VLSI_ChipSet:   mov     MachineType,CHIP_VLSI
                mov     dx,offset msg_VLSI
                jmp     PCI_Check_OK    ; 탊^[  Ή0.40

KX450_Chipset:  mov     MachineType,CHIP_450KX
                mov     dx,offset msg_intel450KX
                jmp     PCI_Check_OK
PCI_Check_OK:   ; ^[
                call    puts
                mov     ax,0B101h       ; Get PCI BIOS status
                int     1Ah             ; PCI BIOS call
                jc      NoPCI_BIOS      ; PCI Check ɎsȂ畁ʂ486@
                cmp     dx,20494350h    ; ?dx=='PCI '
                je      ExistPCIBIOS    ; PCI VOi`ȂȂ畁ʂ486@
NoPCI_BIOS:
                mov     dx,offset msg_nopcibios
                call    puts
                clc
                ret
ExistPCIBIOS:
                mov     dx,offset msg_machine
                call    puts
                clc
                ret

NEC_ChipSet:    
                mov     MachineType,CHIP_UNKNOWN
                jmp     PCI_Check_fail  ; ^[
PCI_Check_fail: ; ^[(unknown)
                stc
                ret
MachineType     DB      00h
msg_nopcibios   DB      "PCI BIOS͂܂.",0
msg_RCC         DB      "PC-9821RvII26 or RsII26 champion chipset",0
msg_NEC         DB      "NEC chipset (9821Na7/H3)",0
msg_VLSI        DB      "VLSI supercore 59x chipset",0
msg_intel       DB      "intel chipset",0
msg_intelP6     DB      "intel 440FX chipset & P6 prosessor",0
msg_intel450KX  DB      "PC-9821St20 or St15, intel 450KX chipset",0
msg_REDWOOD     DB      "RED WOOD chipset"
msg_machine     DB      "@ł.",13,10,0
PCI_Check       ENDP


;----------------------------------------------------------------
;       ROM --> RAM  D000    \Ԃɂ     Ԓl CF
;----------------------------------------------------------------
ROM_RAM_PCI     PROC   near
                mov     al,MachineType
                cmp     al,CHIP_RCC
                je      ROM_RAM_RCC
                cmp     al,CHIP_VLSI
                je      ROM_RAM_VLSI
                cmp     al,CHIP_450KX
                je      ROM_RAM_KX450
                test    al,CHIP_Intel
                jnz     ROM_RAM_intel

;        mov bx,offset SegmentList
ROM_RAM_legacy:
                or      al,al
                jnz     ROM_RAM_fail 
                test    UseEMJ,1
                jz      ROM_RAM_fail 
                test    HiresoFlag,1
                jz      @f
                call    SetEMJ_E800_H
                jmp     ROM_RAM_OK
        @@:
IFDEF   IsDeviceDriver  
;;                call    SetEMJ_A400
ENDIF
        @@: 
                test    SegD000,1
                jnz     @f
                call    SetEMJ_D000
        @@:     test    SegD400,1
                jnz     @f
                call    SetEMJ_D400
                mov     dx,offset msg_EMJSET      
                call    puts
        @@:     test    SegD800,1
                jnz     @f
                call    SetEMJ_D800
        @@:
                jmp     ROM_RAM_OK

ROM_RAM_RCC:    mov     bx,0
                test    SegD000,1
                jnz     @f
                or      BL,00000011b
        @@:     test    SegD400,1
                jnz     @f
                or      BL,00001100b
        @@:     test    SegE800,1
                jnz     @f
                or      BH,00001100b
        @@:     
                mov     eax,80000070h
                mov     dx,0CF8h
                out     dx,eax
                mov     dx,0CFEh  ; 
                in      ax,dx
                or      ax,bx
                out     dx,ax
                call    SetMTRR_D0_E0   ; vP6 CPUÃ`bvZbgȂ
                JMP     ROM_RAM_OK
                
ROM_RAM_KX450:  
                mov     eax,8000A05Ch   ; St20,St15 ̓foCX20
                mov     dx,0CF8h ; 59=F000,5A=C0,5B=C8,5C=D0,5D=D8,5E=E0,5F=E8
                out     dx,eax
                mov     dx,0CFCh
                in      eax,dx  ; ܂ǂݍ
                cmp     eax,0FFFFFFFFh
                je      ROM_RAM_fail    ; ܂蓾Ȃǂ߂ȂG[
                test    SegD000,1
                jnz     @f
                or      eax,00000003h
        @@:     test    SegD400,1
                jnz     @f
                or      eax,00000030h
        @@:     test    SegE800,1
                jnz     @f
                or      eax,03000000h
        @@:     test    SegEC00,1
                jnz     @f
                or      eax,30000000h
        @@:     
                out     dx,eax

                mov     eax,8000C85Ch   ; St20,St15 ̓foCX25
                mov     dx,0CF8h ; 59=F000,5A=C0,5B=C8,5C=D0,5D=D8,5E=E0,5F=E8
                out     dx,eax
                mov     dx,0CFCh
                in      eax,dx  ; ܂ǂݍ
                test    SegD000,1
                jnz     @f
                and     eax,0FFFFFFF0h
        @@:     test    SegD400,1
                jnz     @f
                and     eax,0FFFFFF0Fh
        @@:     test    SegE800,1
                jnz     @f
                and     eax,0F0FFFFFFh
        @@:     test    SegEC00,1
                jnz     @f
                and     eax,0FFFFFFFh
        @@:     
                out     dx,eax

                JMP     ROM_RAM_OK

                jmp     EnterIntelChipset ; intelݒ̓rɓ荞
ROM_RAM_intel:  mov     bx,0000h        ; bxbus0/dev0/fnc0ݒ
                cmp     al,CHIP_Intel_P6 
                jne     @f
EnterIntelChipset:
                call    SetMTRR_D0_E0   ; CPUP6̂ƂMTRR
        @@:     
                mov     eax,8000005Ch   ;intel Chipset's PAM
                mov     dx,0CF8h ; 59=F000,5A=C0,5B=C8,5C=D0,5D=D8,5E=E0,5F=E8
                out     dx,eax
                mov     dx,0CFCh
                in      eax,dx  ; ܂ǂݍ
                cmp     eax,0FFFFFFFFh
                je      ROM_RAM_fail    ; ܂蓾Ȃǂ߂ȂG[
                test    SegD000,1
                jnz     @f
                or      eax,00000007h
        @@:     test    SegD400,1
                jnz     @f
                or      eax,00000070h
        @@:     test    SegE800,1
                jnz     @f
                or      eax,07000000h
        @@:     test    SegEC00,1
                jnz     @f
                or      eax,70000000h
        @@:     
                out     dx,eax
                JMP     ROM_RAM_OK

ROM_RAM_VLSI:  ; VLSI chipset(WildCat) PAM
                mov     bl,0
                test    SegD000,1
                jnz     @f
                or      bl,00000011b
        @@:     test    SegD400,1
                jnz     @f
                or      bl,00001100b
        @@:     
                mov     eax,80000064h ; 66-67h
                mov     dx,0CF8h
                out     dx,eax
                mov     dx,0CFFh
                in      al,dx
                or      al,bl
                out     dx,al
                mov     eax,8000006Ch  ; (6F)
                mov     dx,0CF8h
                out     dx,eax
                mov     dx,0CFFh
                in      al,dx
                or      al,bl
                out     dx,al

                mov     bl,0
                test    SegE800,1
                jnz     @f; ECE8E4E0
                or      bl, 00110000b
        @@:     test    SegEC00,1
                or      bl, 11000000b
                jnz     @f
        @@:     
                mov     eax,80000068h
                mov     dx,0CF8h
                out     dx,eax
                mov     dx,0CFCh
                in      al,dx
                or      al,bl
                out     dx,al
                mov     eax,80000070h
                mov     dx,0CF8h
                out     dx,eax
                mov     dx,0CFCh
                in      al,dx
                or      al,bl
                out     dx,al
                jmp     ROM_RAM_OK

ROM_RAM_OTHERS: ; ̑̃`bvZbg
                jmp     ROM_RAM_fail ; R[h͖쐬Ȃ̂Ŏs
                
ROM_RAM_fail:   ; Ή@̏ꍇs
                stc
                ret
ROM_RAM_OK:     ; 
                clc
                ret
ROM_RAM_PCI    ENDP


;-----------------------------------------------
;       AccessMTRR4K    
;-----------------------------------------------
AccessMTRR4K    PROC   near     ;EBX,ECX,SI
                pushf   
                cli     
                wbinvd  
                rdmsr   
                popf

                pushf   
                cli     
                test    si,1
                jz      @f
                mov     EDX,EBX
                jmp     setEDXEAX
        @@:     mov     EAX,EBX
setEDXEAX:
                wrmsr
                invd
                popf

                ret
AccessMTRR4K    ENDP
;-----------------------------------------------
;       SetMTRR_D0_E0    
;-----------------------------------------------
SetMTRR_D0_E0   PROC   near
                push    eax
                push    ebx
                push    ecx
                push    edx
                mov     dx,043Fh
                mov     al,0A0h   
                out     dx,al
                
                mov     EBX,06060606h
                mov     si,0
                test    SegD000,1
                jz      @f
                mov     ECX,026Ah 
                call    AccessMTRR4K
        @@:
                mov     si,1
                test    SegD400,1
                jz      @f
                mov     ECX,026Ah 
                call    AccessMTRR4K
        @@:
                mov     si,0
                test    SegE800,1
                jz      @f
                mov     ECX,026Dh 
                call    AccessMTRR4K
        @@:
                mov     si,1
                test    SegEC00,1
                jz      @f
                mov     ECX,026Dh 
                call    AccessMTRR4K
        @@:
                pop     edx
                pop     ecx
                pop     ebx
                pop     eax
                ret
SetMTRR_D0_E0    ENDP

