;----------------------------------------------
;       _digit386
;       input       eax = value
;       ; var       _digit_n    = cx ; digit
;       ; var       _digit_div  = bx ; div
;       output      ds:[dx] = output string
;----------------------------------------------
                PUBLIC  _digit386
_digit386       PROC    NEAR
                push    es
                push    si
                push    bx
                push    ds
                pop     es
                push    eax
                cmp     cx,0FFFFh
                je      Noalign386
                xor     dx,dx
                mov     ax,128
                div     _digit_div
                cmp     cx,ax
                jbe     cx_ok1_386
                mov     cx,ax
cx_ok1_386:         
                cmp     cx,1
                jae     cx_ok2_386
                mov     cx,ax
cx_ok2_386:     nop
Noalign386:     nop
                std
                 mov     di,offset ds:_convert$end
                 xor     ebx,ebx
                 mov     bx,ds:_digit_div
                 mov    al,0
                 stosb   
                pop     eax  ;   ax=value
                xor     edx,edx
_digit386_ent:     
                div     ebx
                mov     si,offset ds:_hextbl
                add     si,dx
                movsb
                dec     cx
                xor     edx,edx
                or      eax,eax
                jnz     _digit386_ent
_digit386_end:     
                cmp     cx,33
                jae     digit386_err
                or      cx,cx
                jz      digit386_err
                mov     al,_digit_zsup
digit386_spc_loop: stosb
               loop     digit386_spc_loop
digit386_err:   
                cld
                inc     di
                mov     dx,di
                pop     bx
                pop     si
                pop     es
                ret
_digit386       ENDP

;-------------------------------------
_digit_div      DW      10
_digit_zsup     DB      ' '
_hextbl         DB      "0123456789ABCDEF"
$KetaBuf33      DB      "                                 "
_convert$end    DB      0

.286
_digit          PROC    NEAR
                push    es
                push    si
                push    bx

                push    ds      ; es=ds
                pop     es
                push    ax
                cmp     cx,0FFFFh
                je      Noalign
                xor     dx,dx
                mov     ax,128
                div     ds:_digit_div
                cmp     cx,ax
                jbe     cx_ok1
                mov     cx,ax
cx_ok1:         
                cmp     cx,1
                jae     cx_ok2
                mov     cx,ax
cx_ok2:         nop
Noalign:        nop
                std
                 mov     di,offset ds:_convert$end
                 xor     bx,bx
                 mov     bx,ds:_digit_div
                 mov    al,0
                 stosb   
                pop     ax  ;   ax=value
                xor     dx,dx
_digit_ent:     
                div     bx
                mov     si,offset ds:_hextbl
                add     si,dx
                movsb
                dec     cx
                xor     dx,dx
                or      ax,ax
                jnz     _digit_ent
_digit_end:     
                cmp     cx,17   ; 17
                jae     digit_err
                or      cx,cx
                jz      digit_err
                mov     al,_digit_zsup
digit_spc_loop: stosb
               loop     digit_spc_loop
digit_err:      
                cld
                inc     di
                mov     dx,di
                pop     bx
                pop     si
                pop     es
                ret
_digit          ENDP

.386