.386
;-----------------------------------
;       80386pTu[`
;-----------------------------------
MemoryCheckEMB  PROC   near   
                test    flagset,F_V86
                jz      main1_mcheck0
                test    flagset,F_386
                jnz     main1_mcheck0
                SETCOLOR  41h
                mov     dx,offset ErrMemTest86
                call    puts
                SETCOLOR  0E1h
                call    beep3
                stc
                ret
main1_mcheck0:
                mov     ax,TargetHandle
                or      ax,ax
                jz      HandleZero
                push    ax
                mov     dx,offset MsgHandle
                call    puts
                pop     ax
                call    print_hex4
                mov     dx,offset MsgH
                call    puts
                call    MemCheckEMB
                ret
MemoryCheckEMB  ENDP

;-----------------------------------
GetAvailEMB     PROC   near
                xor     dx,dx
                test    flagset,F_386
                jz      GetAvail16
                test    flagset,F_VER2
                jNz     GetAvail16
GetAvail32:     mov     ah,88h
                call    [XMM_driver]
                or      eax,eax
                jz      XMM3_err
                mov     XMSfreeD,eax
                mov     XMSsizeD,edx
                mov     UpperLimitAddr,ecx
                or      flagset,F_XMMEX
                clc
                ret
    XMM3_err:
                xor     edx,edx
                xor     eax,eax
                mov     XMSfreeD,eax
                mov     XMSsizeD,edx
                cmp     bl,80h
                je      GetAvail16  ; if not implemented, then retry XMS2 func.
                or      flagset,F_XMMEX
                cmp     bl,0A0h
                je      AvailableEMB_0
                stc
                ret
.286
GetAvail16:
                mov     ah,08h
                call    [XMM_driver]
                or      ax,ax
                jz      XMM2_err
                mov     XMSfree,ax
                mov     XMSsize,dx
                clc
                ret
    XMM2_err:   xor     ax,ax
                mov     XMSfree,ax
                mov     XMSsize,ax
                cmp     bl,0A0h
                je      AvailableEMB_0
                stc
                ret
AvailableEMB_0: clc
                ret
GetAvailEMB     ENDP

.386

;-----------------------------------
ScanHandleEMB3  PROC   near
                mov     eax,XMSfreeD
                cmp     eax,XMSsizeD
                je      EMBfull3
                SETCOLOR   061h 
                mov     eax,XMSfreeD
                call    print_decimal
                SETCOLOR   0E1h 
                mov     dx,offset KB_freeMax
                call    puts
EMBfull3:
                SETCOLOR   061h 
                mov     eax,XMSsizeD
                call    print_decimal
                SETCOLOR   0E1h 
                mov     dx,offset KB_freeTotal
                call    puts
;**********  nhꗗ𓾂V3 *******
                xor     eax,eax
                mov     existence,al
                mov     handle,ax
HandleScanLoop3:
                mov     dx,handle
                mov     ax,8E00H
                call    [XMM_driver]
                or      ax,ax
                jz      nohandl3
;found  
                mov     existence,1
                mov     KBsizeD,edx

                mov     dx,offset MsgHandle
                call    puts
                mov     ax,handle
                mov     cx,4
                call    print_hex4

                mov     dx,offset Msg_H_base
                call    puts
;  x[XAhX\
                mov     ax,0C00H        ;lock
                mov     dx,handle
                call    [XMM_driver]
                or      ax,ax

                jz      nohandl3
                push    dx      ; seg
                push    bx      ; ofs
                mov     ax,0D00H        ;unlock
                mov     dx,handle
                call    [XMM_driver]
                pop     eax
;                mov     LinearAddr,eax

                call    print_hexadec
                mov     dx,offset Msg_h_
                call    puts
;  TCY\
                SETCOLOR   0A1h 
                mov     eax,KBsizeD
                call    print_decimal
                SETCOLOR   0E1h 
                mov     dx,offset Msg_KB
                call    puts

                mov     dx,offset XMSmsg_L
                call    puts
                
                mov     eax,KBsizeD
                shl     eax,10
                call    print_hexadec
                mov     dx,offset XMSmsg_R
                call    puts

nohandl3:       mov     ax,maxhandle
                inc     handle
                cmp     handle,ax
                jb      HandleScanLoop3
;--end of loop
                cmp     existence,0
                jnz     exist
                mov     dx,offset ErrNoEMB
                call    puts
exist:          
                clc
                RET
ScanHandleEMB3  ENDP

;======= EMBmۃ[` 32bit/16bit ==========
AllocateEMB     PROC   near
                mov     ax,TargetSize
                test    flagset,F_386
                jz      @f
                mov     eax,TargetSizeD
                or      eax,eax
                jz      CancelAlloc
        @@:
                test    flagset,F_XMMEX
                jz      AllocateEMB16
AllocateEMB32:
                mov     edx,TargetSizeD
                xor     eax,eax
                mov     ah,89h
                call    [XMM_driver]
                jmp     Allocated
AllocateEMB16:
                mov     dx,TargetSize
                mov     ax,0900H
                call    [XMM_driver]
Allocated:
                or      ax,ax
                jnz     AllocEMB_OK
                SETCOLOR   041h 
                mov     dx,offset MsgAllocFail
                call    puts
                SETCOLOR   0E1h 
CancelAlloc:
                call    beep3
                stc
                RET
AllocEMB_OK:    clc
                RET
AllocateEMB     ENDP
;----------------------------------
;============EMB chk[`(UR)=================
MemCheckEMB     PROC   near
                mov     bl,0
                test    flagset,F_V86
                jz      @f
                SETCOLOR  41h
                mov     dx,offset ErrMemTest86
                call    puts
                SETCOLOR  0E1h
                jmp     LockFail3
        @@:
                mov     dx,TargetHandle
                mov     ah,0Ch        ;܂lockĂ݂
                call    [XMM_driver]
                or      ax,ax
                jz      LockFail2
                mov     LinearAddrL,bx
                mov     LinearAddrH,dx

                mov     dx,TargetHandle
                test    flagset,F_XMMEX
                jz      MemCheck16bit
MemCheck32bit:
                mov     ah,8Eh
                call    [XMM_driver]
                or      ax,ax
                jz      LockFail2
                shl     edx,10
                jmp     MemCheckStart
MemCheck16bit:
                mov     ah,0Eh
                call    [XMM_driver]
                or      ax,ax
                jz      LockFail2
                and     edx,0000FFFFh
                shl     edx,10
MemCheckStart:  mov     TargetSizeD,edx
                 call    debug3
                call    GoPmodeGS
                mov     ebx,LinearAddr
                mov     ecx,TargetSizeD
                or      ecx,ecx
                jz      LockFail2
                shr     ecx,2
                mov     eax,0E5E5E5E5h
          @@:   mov     gs:[ebx],eax
                add     ebx,4
               loopd    @b
                mov     ebx,LinearAddr
                mov     ecx,TargetSizeD
                shr     ecx,2
          @@:   cmp     gs:[ebx],eax
                jne     MemDataErr
                add     ebx,4
               loopd    @b
MemDataErr:     or      ecx,ecx
                mov     dx,offset MsgOK_CRLF
                jz      MemCheckEnd
                mov     dx,offset ErrMemData
MemCheckEnd:    call    puts
                mov     dx,TargetHandle
                mov     ah,0Dh        ;unlock
                call    [XMM_driver]
                clc
                ret
LockFail2:
                mov     dx,TargetHandle
                mov     ah,0Dh        ;unlock
                call    [XMM_driver]
                call    beep3
LockFail3:      mov     dx,offset ErrMemCheck
                call    puts
                stc
                ret
ErrMemData      DB      " Test failure!",13,10,0
                ret
MemCheckEMB    ENDP
;-----------------------------------
