;------------------------------------------------------------------------------
; SCSI BIOS RAM for i486 machine V2.30  Copyright(C) 2004,19-25 DOSsoft(܂)
;------------------------------------------------------------------------------
LEGACY386 equ 1
;IPLWARE equ 1
.186
IDE_equip       equ     10h     ; IDE BIOS bit
E10_equip       equ     20h     ; E10 BIOS bit
SASI_equip      equ     40h     ;SASI BIOS bit
SND_equip       equ     80h     ; SND BIOS bit
TEMP_ADDR       equ     5E00h

; ]}N di=si=ax=0̏ACXɃoCgݒ
PrepMemMove     macro   MEM_BYTE:REQ
                mov     cx,MEM_BYTE/2
                xor     ax,ax
                mov     di,ax
                mov     si,ax
endm

; 486 instruction}N 
BSWAP           macro   REG32X 
                DB      66h
                DB      0Fh
                DB      0C8h    ; EAX
                endm

; flagset bit`
F_HIRESO        = 01h   ; 1high reso[h, 0normal[h
F_AMATE1        = 02h   ; 1Amate-1
F_9821          = 04h   ; 1PC-9821xx
F_E10           = 08h   ; 1PC-9821A-E10 or FA02, 0other
F_RADA          = 10h   ; 19801RA-BX@
F_RETRO         = 20h   ; 1Ńg@
F_EPSON         = 40h   ; 1EPSON ID or 286@
F_H98           = 80h   ; 1H98

flagset         equ     byte ptr [bp-02h] ; }Vʁ^[h̃rbgtO
BuiltInDev      equ     byte ptr [bp-03h] ; 043Fhl C0,C2,C4,C6̂ꂩ
equip           equ     byte ptr [bp-04h] ; 053Dhl 
MemWindowAddr   equ     byte ptr [bp-05h] ; 08-09 BANK window address in EXROM
MemWindowNative equ     byte ptr [bp-06h] ; 08-09 BANK window native address 
Result          equ     byte ptr [bp-07h]
PortMask        equ     byte ptr [bp-08h] ; H98p
MachineID       equ     byte ptr [bp-09h] ; Machine ID
temp            equ     byte ptr [bp-0Ah] ; H98p

ROW             equ     word ptr [bp-0Ch] ; \s
COLUMN          equ     word ptr [bp-0Eh] ; \J
SegTVRAM        equ     word ptr [bp-10h] ; T-VRAM̃ZOgA000/E000
MemBankIOAddr   equ     word ptr [bp-12h] ; (N)0461h / (H)0091h
SegPhysIDEBIOS  equ     word ptr [bp-14h] ; IDE BIOSZOgiIj
SegMMapIDEBIOS  equ     word ptr [bp-16h] ; IDE BIOSZOgiRAMmappingj
SegPhysSCSIBIOS equ     word ptr [bp-18h] ;SCSI BIOSZOgiIj
SegMMapSCSIBIOS equ     word ptr [bp-1Ah] ;SCSI BIOSZOgiRAMmappingj
SegTempMem      equ     word ptr [bp-1Ch] ; IPLwarêƂ5C00h
SegSCSIBIOS     equ     word ptr [bp-1Eh] ; H98pSCSI BIOSZOg(ϐ)
SegSCSIBIOS_E   equ     word ptr [bp-20h] ; H98p
PortROMRAM      equ     word ptr [bp-22h] ; H98p
ChipSet         equ    dword ptr [bp-28h] ; H98p

code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:          jmp     begin

TitleMsg        DW      offset  ttl_SCSIRAM
IFDEF   LEGACY386
ttl_SCSIRAM     DB 0E5h," SCSIBIOSRAM mSCSI_RAMn386/486O@p  Ver.2.30 (C) 2025 ܂ ",13,10,0
ELSE
ttl_SCSIRAM     DB 0E5h," SCSIBIOSRAM mSCSI_RAMn Ver.2.30  Copyright(C) 2004,2019-25 ܂ ",13,10,0
ENDIF

begin:
                enter   32h,0
                xor     ax,ax
                mov     equip,al
                mov     BuiltInDev,al
                mov     COLUMN,ax
                mov     Result,al
IFDEF   LEGACY386
                mov     flagset,F_RADA      ; al
ELSE
                mov     flagset,al
ENDIF
                mov     ROW,1
                call    SetSegTempMem

                call    ResoModeCheck0  ; es=T-VRAM segment
                mov     dx,TitleMsg
                call    _puts

                call    CPU386check
                mov     dx,offset wrong_CPU
                jc      CancelPatch

                call    CheckEPSON
                mov     dx,offset wrong_EPSON
                jc      CancelPatch

                test    flagset,F_H98
                jz      NotH98
;;;;             mov     dx,offset H98_msg   ; H98ÔƂ͂̂Qs
;;;;             jmp     CancelPatch
                call    EnvCheckH98     ; H98`FbN CYŔH98
                jc      NotH98
                jmp     H98_machine
                
NotH98:         call    PCI_9821Check       ; confign[hEFA
                mov     dx,offset PCI_machine
                jc      CancelPatch
                call    CheckMateModel
                jc      NotAmate
NotAmate:

                call    Check_DC00_EE00
                mov     dx,offset absent_msg
                jc      CancelPatch

                call    Check4BIOS
                mov     dx,offset absent_msg
                jc      CancelPatch

; Ver. 2.27 iE10 or FA02jȊÔƂ͋IRAMo~߂
                test    flagset,F_E10
                jnz     @f
                mov     dx,043Fh        ; Rs[O
                mov     al,BuiltInDev   ; SCSI RAM 
                AND     al,11000010b    ; ROMɈU   C6-->C2  C4-->C0
                out     dx,al           ; ؂ւ
        @@:
                call    CopyROMtemp     ; (E10ȊÔƂ)ROMRs[
        ; 92{[hBIOSւ̃pb`
                mov     es,SegTempMem
                call    S92_patch       ; PC-9801-92/ A-E10 LR[h̃pb`
                jc      patn92_notfound ; p^[ȂΎ
                or      Result,1
                jmp     capa_patch_end
patn92_notfound:        
                call    CopyROMtemp     ; pb`Ɏs烊[h
        ; Other SCSI{[hBIOSւ̃pb`
                mov     es,SegTempMem
;               call    OEM_patch       ; other SCSI R[h̃pb`
;               jc      OEM_notfound    ; p^[ȂΎ
;               or      Result,2
                jmp     capa_patch_end
OEM_notfound:
                call    CopyROMtemp     ; pb`Ɏs烊[h
capa_patch_end: 
                call    ROMRAM486_SCSI  ; 80000oNC0000𓊉eJn
                call    DisableParityError  ; peBG[N肤̂NMI֎~
                pushf
                cli     ; 犄֎~
                call    CopyMEMRAM      ; C痠RAM֓]
IFDEF   LEGACY386
                test    flagset,F_RADA
                jz      NotRADA
;               test    flagset,F_HIRESO
;               jnz     NotRADA
                call    FixSYSBIOS2
ENDIF
     NotRADA:   call    RAMROM486_SCSI  ; 80000oNƂɖ߂
                popf    ; 荞݋֎~Ԃ܂

                call    EnableParityError       ; NMIJn

                mov     dx,offset OK_msg
CancelPatch:    call    _puts

                test    Result,1
                jz      @f
                mov     dx,offset Patched92BIOS
                call    _puts
        @@:     

                call    SaveFlags
EndJob:
ifdef   IPLWARE
                call    shiftkey_check
endif
                leave
ifdef   IPLWARE
                RETF
else
                mov     ax,4C00h
                int 21h
endif
;               ŏI

;--------------------------------------------------------


wrong_machine   DB  041h,"  ̋@ł͎gpł܂.",13,10,0
wrong_CPU       DB  041h,"  CPUł͎gpł܂.",13,10,0
wrong_EPSON     DB  041h,"  EPSON PCł͎gpł܂.",13,10,0
;H98_msg         DB  041h,"  PC-H98ł͎gpł܂.",13,10,0
PCI_machine     DB  041h,"  PCI bus ø̋@ł͎gpł܂.",13,10,0
OK_msg          DB  0E1h,"  SCSI{[hBIOSshadow RAMɃRs[܂.",13,10,0
E10exist_msg    DB  0A1h,"   SCSI(E10){[ho܂.",13,10,0
H98m105_msg     DB  0E1h,"  PC-H98 seriesSCSIo܂.",13,10,0
absent_msg      DB  0C1h,"  DC000hiʲڿނłEE000hjSCSI{[hBIOS͌o܂ł.",13,10,0
absentH98_msg   DB  061h,"  H98 model(U)105 SCSI/PC-H98-B12{[h͌o܂ł.",13,10,0
PatchedB12BIOS  DB  0E1h,"  PC-H98 model105 SCSI BIOS̗e1GBւ̏Cpb`s܂.",13,10,0
Patched92BIOS   DB  0E1h,"  PC-9801-92݊{[h̗e1GBւ̏Cpb`s܂.",13,10,0

;--------------------------------------------------------
include H98scsi.inc
;--------------------------------------------------------
;---------------------------------------------------------------
;       peBG[֘A
;---------------------------------------------------------------
ChangeNMI       PROC   near
                add     al,8
                out     37h,al  ; Parity check disable 
                jmp     $+2
                jmp     $+2
                out     50h,al  ; NMI disable
                jmp     $+2
                jmp     $+2
                ret
ChangeNMI       ENDP
DisableParityError      PROC   near
                mov     al,0
                call    ChangeNMI
                ret
DisableParityError      ENDP

EnableParityError       PROC   near
                mov     al,1
                call    ChangeNMI
                ret
EnableParityError       ENDP


;--------------------------------------------------------
;       ROMRAM486_SCSI  
;--------------------------------------------------------
ROMRAM486_SCSI  PROC    near
                cld
                mov     dx,043Fh ; 
                mov     al,0A0h   ; clear CPU cache 
                out     dx,al

                mov     dx,MemBankIOAddr ; 8-9 bank selected address C000
                mov     al,MemWindowAddr
                out     dx,al

                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,02h   ; BIOS RAM window access enable 
                or      al,equip
                out     dx,al
                ret
ROMRAM486_SCSI  ENDP

;----------------------------------------------------------------------------
;       CopyROMtemp  I/O 053Dh C-bus SCSIROMoĂԂɂĂ痈
;--------------------------------------------------------------------------
CopyROMtemp     PROC   near ; UCɃRs[悤ύX2022-9-24
                push    es      
                push    ds

                pushf   ; ROMoN֑ؑOɊ荞݋֎~ƂĂ
                cli
                mov     dx,0CC0h        ; SCSI ROMʑioNjɕύX
                mov     al,30h
                out     dx,al
                out     5Fh,al          ; wait
                mov     dx,0CC2h
                in      al,dx
                or      al,40h          ; bit 6 -->1
                out     dx,al

                mov     ds,SegPhysSCSIBIOS      ; DC00AhX
                mov     ax,SegTempMem;          ; 5C00C
                add     ax,0100h                ; 5D00ɂ
                mov     es,ax                   ; 
                PrepMemMove     1000h
          rep   movsw   ; Rs[ 4KB

                mov     dx,0CC0h        ; SCSI ROMʑi\oNjɕύX
                mov     al,30h
                out     dx,al
                out     5Fh,al          ; wait
                mov     dx,0CC2h
                in      al,dx
                and     al,10111111b    ; bit 6 -->0
                out     dx,al           ; \oNɐؑ

                popf    ; oNύX͊֎~ƂĂ 2022-9-24

                mov     ds,SegPhysSCSIBIOS      ; DC00AhX
                mov     es,SegTempMem;          ; 5C00C
                PrepMemMove     1000h
          rep   movsw   ; Rs[ 4KB

                pop     ds
                pop     es
                ret
CopyROMtemp     ENDP

;------------------------------------------------------------------
;       CopyMEMRAM      C̓eVhERAMփRs[
;------------------------------------------------------------------
CopyMEMRAM      PROC   near
if 0
                mov     al,08h  ; peBG[N肤̂ŉ
                out     37h,al  ; Parity check disable 
                jmp     $+2
                out     50h,al  ; NMI disable
                jmp     $+2
endif
                push    ds
                mov     ds,SegTempMem           ; 5C00C
                mov     es,SegMMapSCSIBIOS      ; 9C00VhERAM
                
                PrepMemMove     2000h
          rep   movsw   ; A8KBł邱Ƃɒ
                pop     ds
if 0
                mov     al,09h  ;
                out     52h,al  ; NMI enable
                jmp     $+2
                out     37h,al  ; Parity check enable
                jmp     $+2
endif
                ret
CopyMEMRAM      ENDP

;--------------------------------------------------------
;       RAMROM486_SCSI
;--------------------------------------------------------
RAMROM486_SCSI  PROC    near
                mov     dx,MemBankIOAddr 
                mov     al,MemWindowNative      
                out     dx,al           ; 8-9 bank selected address 8000h

                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,06h   ; RAM window disable=1, BIOS RAM select=1
                or      al,equip
                out     dx,al

                mov     dx,043Fh ; SCSI_RAME10PATł͕Kv
                mov     al,BuiltInDev
                or      al,0C4h  ; SCSI BIOS DC000h changed to RAM
                out     dx,al
                mov     BuiltInDev,al

                mov     dx,043Fh ; 
                mov     al,0A0h  ; clear cache 
                out     dx,al
                ret
RAMROM486_SCSI  ENDP

;--------------------------------------------------------------
;       ResoModeCheck0   ( \JnOɂPxĂԂ )
;--------------------------------------------------2019/7/8----
ResoModeCheck0   PROC    near
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     ah,ds:[0458h]   ; H98 check
                mov     al,ds:[0501h]   ; hi-reso check
                pop     ds

                test    ah,80h
                jz      @f
                or      flagset,F_H98
        @@:     
                mov     bx,0A000h
                mov     dx,0461h                ; EBhE|[g
                mov     MemWindowAddr,0Ch       ; EBhEmapping
                mov     MemWindowNative,08h     ; 8bank
                test    al,8
                jz      @f
                or      flagset,F_HIRESO
                mov     bx,0E000h
                mov     dx,0091h                ; nC]̃EBhE|[g
                mov     MemWindowAddr,0Eh       ; EBhEmapping
                mov     MemWindowNative,10h     ; HIMEM.SYS삵ĂȂƂO
                mov     RESET_SEG,0F800h        ; 
        @@:
                mov     SegTVRAM,bx             ; eLXgVRAM̃ZOgm肷
                mov     MemBankIOAddr,dx        ; EBhE|[g
                ret
ResoModeCheck0   ENDP

.386
Check_DC00_EE00 PROC   near
                call    GetSegSCSIBIOS
                push    ds
                mov     ds,dx
                mov     edx,ds:[0]      ; ? C-BUS ROM
                mov     eax,ds:[8]      ; ? C-BUS SCSI ROM
                mov     ecx,ds:[60h]    ; ? C-BUS 100 ROM
                pop     ds
                cmp     edx,0CB9090CBh  ; C-BUS ROM signature 
                jne     No_SCSI_adapter
                cmp     eax,02AA5590h   ; C-BUS SCSI signature 
                jne     No_SCSI_adapter
                cmp     ecx,534F4942h   ; 100 board  signature 
                je      No_SCSI_adapter
                clc
                RET
No_SCSI_adapter:
                stc
                RET
Check_DC00_EE00 ENDP

;-----------------------------------------------------------
;       Check4BIOS ( equiped peripherals and its BIOS ) 
;----------------------------------2022/9/24--2025/7/12-----
Check4BIOS      PROC    near
                push    ds
                call    GetSegIDEBIOS
                mov     ds,dx
                mov     eax,ds:[0008h]  ; ? C-BUS ROM
                pop     ds              ; ROM ID2A/AAȊŐ@邪,,,
                cmp     eax,2AAA5590h   ; C-BUS ROM signature 
                jnz     @f
                or      equip,IDE_equip
                or      BuiltInDev,0C2h
        @@:     

; SASI BIOS̒
                test    flagset,F_HIRESO
                jnz     EndCheckBIOS    ; ȉ̓nC]֌W
if 0 ; ϐflagsetgȂƂȉ̃R[h
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     al,ds:[0501h]   ; nC]`FbN
                pop     ds
                test    al,8            ; nC]ɂ
                jnz     EndCheckBIOS    ; SASISOUND BIOŜŃLZ
endif
                mov     ax,0D700h       ;  D700 𒲂ׂ
                push    ds
                mov     ds,ax
                mov     eax,ds:[0]
                pop     ds
                or      eax,eax         ; LROMf[^͖iRAM?j
                jz      NO_SASI_BIOS    ; Ȃ΃LZ
                cmp     eax,0FFFFFFFFh  ; ROMf[^͑SȂ
                je      NO_SASI_BIOS    ; Ȃ΃LZ
; 2025/7/12 D700ɉf[^ꍇ
                mov     ax,0D500h       ; 16KBȆ̏ꏊiȂǂł悢j
                push    ds
                mov     ds,ax
                mov     eax,ds:[0]
                pop     ds
                cmp     eax,0FFFFFFFFh  ; ROMf[^͑S
                jne     NO_SASI_BIOS    ; 悤Ȃ炻EMS RAMȂ̂ŃLZ
                ; D500Ƀf[^D700̃f[^SASIƔf邱Ƃɂ
                or      equip,SASI_equip  ; SASI BIOS RAM݂̂Ƃ
                or      BuiltInDev,0C2h   ; SASI BIOS RAMłƂ
NO_SASI_BIOS:
                nop
                nop

; rgC TEhBIOS̒i2025/7/12ǉj
                mov     ax,0CC00h       ; ROM CC00𒲂ׂ
                mov     es,ax
                mov     eax,es:[bx]
                or      eax,eax
                jz      NO_SND_BIOS
                cmp     eax,0FFFFFFFFh  ; ROM not exist
                je      NO_SND_BIOS     ; FFȂLZ
                call    IsBuiltInBIOS   ; f[^̂łɃ`FbN
                jc      NO_SND_BIOS     ; L[ŋAĂꍇ̓TEhBIOS
                or      equip, SND_equip
                jmp     EndCheckBIOS
NO_SND_BIOS:    and     equip,01111111b ; BIOS͂Ȃ̂ő݃tO߂

EndCheckBIOS:
                clc
                ret
SCSIBIOS_absent:
                stc
                ret
Check4BIOS      ENDP

.386
;--------------------------------------------------------------------------
;       IsBuiltInBIOS   SOUND BIOS{̓̂ǂ`FbN es=CC00
;----------------------------@ˑȂ@-----2022/9/24--------------
IsBuiltInBIOS   PROC   near     ; nC][hɎsĂ͂Ȃ
                push    es
                push    ds
                mov     ax,es
                mov     ds,ax
                mov     es,SegTempMem
                PrepMemMove     1000h
        rep     movsw
                pop     ds
                pop     es

                mov     dx,053Dh
                mov     al,equip        ; 
                or      al,10000010b    ; SOUND BIOS݃tO𗧂Ă
                out     dx,al           ; ݒs
                
                PrepMemMove     1000h
                mov     eax,es:[di]

                mov     dx,0461h
                mov     al,0Ch
                out     dx,al

                push    es
                push    ds
                mov     ax,8C00h        ; RAM BIOS8C00ɂ͂
                mov     es,ax
                mov     ds,SegTempMem
                mov     cx,1000h/2      ; 擪8KBr
        rep     cmpsw                   ; SvZEROtOCX=0
                pop     ds
                pop     es

                mov     dx,0461h
                mov     al,08h
                out     dx,al

                or      cx,cx
                jnz     NoBuiltInBIOS   ; srȂrgCBIOSłȂ
                mov     al,10000010b    ; vȂ炻̓rgCBIOS
                or      equip,al        ; Ȃ̂ŃtO𗧂ĂNCŖ߂
                clc                     ; BIOSƂNC
                ret
NoBuiltInBIOS:  mov     al,equip        ;
                and     al,01111111b    ; BIOŜ͖őbitւ܂
                mov     equip,al        ; tOɂݒԂ
                out     dx,al           ; ݒs
                stc                     ; BIOSƂCY
                ret
IsBuiltInBIOS   ENDP
.186

;---------------------------------------------------------------------
;       Get IDE BIOS segment address   ES:shadowed RAM   DX:real ROM
;---------------------------------------------------------------------1.10
GetSegIDEBIOS   PROC   near
                mov     ax,09800h   ; IDE BIOS address of memory window 
                mov     dx,0D800h   ; IDE BIOS address (physical)
                test    flagset,F_HIRESO        ; Normal mode
                jz      @f  ; Hiresolution mode
                mov     ax,08600h   ; IDE BIOS address of memory window 
                mov     dx,0E600h   ; IDE BIOS address (physical)
        @@:     
                mov     SegPhysIDEBIOS,dx
                mov     SegMMapIDEBIOS,ax
                ret
GetSegIDEBIOS   ENDP

;---------------------------------------------------------------------
;       Get SCSI BIOS segment address   ES:shadowed RAM   DX:real ROM
;---------------------------------------------------------------------1.10
GetSegSCSIBIOS  PROC    near
                mov     ax,09C00h   ; SCSI BIOS address of memory window 
                mov     dx,0DC00h   ; SCSI BIOS address (physical)
                test    flagset,F_HIRESO        ; Normal mode
                jz      @f          ; Hiresolution mode
                mov     ax,08E00h   ; SCSI BIOS address of memory window 
                mov     dx,0EE00h   ; SCSI BIOS address (physical)
        @@:     
                mov     SegPhysSCSIBIOS,dx
                mov     SegMMapSCSIBIOS,ax
                ret
GetSegSCSIBIOS  ENDP

;-------------------------------------------------------
;       CPU386check
;-------------------------------------------------------
CPU386check     PROC   near
                pushf
                pop     ax
                pushf
                or      ax,4000h
                push    ax
                popf
                pushf
                pop     ax
                popf
                and     ax,0C000h
                cmp     ax,4000h        
                jNe     Not386
                clc
                ret
Not386:         stc
                ret
CPU386check     ENDP

;----------------------------------------------------
;       FixSYSBIOS2     V2.24 
;----------------------------------------------------
FixSYSBIOS2     PROC   near
                mov     al,BuiltInDev   ; 00/C2/C4/C6̏
                and     al,11000010b    ; bit 1ێ,bit 2 
                or      al,11000000b    ; or C0
                mov     Value043F,al    ; ϐɂۊ
                mov     al,0Eh          ; SYSTEM BIOS E000-FFFFoN
                mov     dx,0461h        ; 8000-9FFFɏo
                out     dx,al
                mov     ax,9FFFh;(0FFFFh-6000h)
                mov     es,ax
                mov     di,0
                
                mov     si,offset PATCH_DATA    ; pb`R[hߍ
                mov     cx, (offset PATCH_DATA_E - offset PATCH_DATA)
        rep     movsb   
                mov     bx,di   ; ݋Ԓ̃AhXBXɕۑ

                xor     ax,ax
                mov     word ptr es:[bx],ax
                mov     dx,ax
                mov     di,ax
                mov     cx,8000h/2      ; F800-FFFF 32KB(4000[h)
                mov     ax,9800h;(0F800h-6000h)  ESF800ɈʒuÂ
                mov     es,ax

          @@:   mov     ax,es:[di]      ;  AXɎ荞
                inc     di
                inc     di      ; P[hOi
                add     dl,al   ; T̒~
                add     dh,ah
               loop     @b
                neg     dl      ; lKl
                neg     dh
                xchg    dl,dh   ; DL͋,DH͊AhXȂ̂ւ

                mov     ax,9FFFh ;(0FFFFh-6000h)
                mov     es,ax           ; BX000BwĂ͂
                mov     es:[bx],dx      ; 000B,000CɃTl
                mov     al,08h          ; EBhEɖ߂
                push    dx
                mov     dx,0461h
                out     dx,al
                pop     dx
                ret     ; ȉFFFF:0ւ̃pb`f[^

;PATCH_DATA      DB      0BAh,3Fh,04h,0B0h       ; mov dx,43fh   mov al,**
PATCH_DATA      DB      0BAh,10h,06h,0B0h       ; test
Value043F       DB      0C0h
JAMPFAR         DB      0EEh,0EAh,0,0
RESET_SEG       DW      0FD80h
PATCH_DATA_E    label byte
FixSYSBIOS2     ENDP


;--------------------------------------------------------
;       SaveFlags       
;-------------------------------2022/9/24----------------
SaveFlags       PROC   near
                test    flagset,F_H98
                jz      @f
                ret
       @@:      
                push    ds
                push    ax
                xor     ax,ax
                mov     ds,ax
                mov     al,equip
                or      al,2
;;              or      ds:[05A7h],al
;;              mov     ds:[05A7h],al
                mov     al,BuiltInDev
;;              or      ds:[05B6h],al
;;              mov     ds:[05B6h],al
                pop     ax
                pop     ds
                ret
SaveFlags       ENDP
;---------------------------------------------------------------------------
SetSegTempMem   PROC   near
ifdef   IPLWARE
                mov     SegTempMem,TEMP_ADDR
else
                mov     dx,cs
                mov     ax,offset DataSegment
                add     ax,16
                shr     ax,4
                add     dx,ax
                mov     SegTempMem,dx
endif
                ret
SetSegTempMem   ENDP


;---------------------------------------------------------------------
;       CheckMateModel       
;---------------------------------------------------------------------
CheckMateModel  PROC   near
                mov     al,MachineID
                or      al,al   ; A1
                jz      a_mate1
                cmp     al,80h  ; A1 H
                je      a_mate1
                
                cmp     al,05h  ; Af
                je      a_mate2
                cmp     al,06h  ; Aps/As2
                je      a_mate2
                cmp     al,81h  ; Af H
                je      a_mate2
                cmp     al,82h  ; Aps/As2 H
                je      a_mate2

                cmp     al,0Dh  ; An
                jz      a_mateN
                cmp     al,83h  ; An H
                jz      a_mateN

                cmp     al,18h  ; Ap3/As3
                jz      a_mate3
                cmp     al,84h  ; Ap3/As3 H
                jz      a_mate3

                cmp     al, 02h ; PC-9821 Ce (with SCSI CD-ROM drive)
                je      C_multi1
Not_Amate_H:    stc
                ret
C_multi1:
a_mate1:
a_mate2:
a_mateN:
a_mate3:
                in      al,0F0h
                and     al,01000000b    ; 40h=SCSI
                test    al,01000000b
                jnz     NoE10board
                ; E10 exist
                or      flagset,F_E10
                or      equip,E10_equip
                mov     dx,offset E10exist_msg
                call    _puts
                or      BuiltInDev,0C4h
NoE10board:
                clc
                ret
CheckMateModel  ENDP


;--------------------------------------------------------------------
;       scan_string     ̔r[`
;       <input>
;       DS:SI rp^[,         CX p^[̃oCg
;       ES:DI p^[ꏊ,         DX ͈̔̓oCg
;       <output>        < j AX,BX,CX,DX,DI >
;       CY =NONE ,  NC= ES:BX   carry0̂Ƃ  ES:BXɌoꏊԂ
;--------------------------------------------------------------------
scan_string     PROC    near
                xor     bx,bx
                sub     dx,cx
                add     dx,di
scan_ent:       mov     ax,ds:[si]
                cmp     ax,es:[di]
                jnz     scan_No_match
                mov     bx,di
                push    cx
                push    si
                push    di
         repz   cmpsb
                or      cx,cx
                pop     di
                pop     si
                pop     cx
                jnz     scan_No_match
                clc                     ; scan OK
                ret
scan_No_match:  inc     di
                cmp     di,dx
                jb      scan_ent
                stc                     ; scan NG
                ret
scan_string     ENDP

;------------------------------------------------------------------
;         shiftkey_check  VtgL[`FbN҂ I
;------------------------------------------------------------------
shiftkey_check  PROC    near
                mov     cx,0FFF0h
WaitEnt:        out     5fh,al
                out     5fh,al
                out     5fh,al
                out     5fh,al
                out     5fh,al
                out     5fh,al
               loop     WaitEnt
ShiftKeyWait:   mov     ah,02h
                int 18h
                test    al,1    ; (bit 0) 1= bit mask of keyboard shift sens
                jnz     ShiftKeyWait
                ret
shiftkey_check  ENDP

ifdef   IPLWARE
include  e:\asmlib\putstrcs.inc   ; \[`͕t܂
else
include  dosputs.inc
endif

.386
;=========================================
S92_patch     PROC    near
; patch1
                mov     si,offset S92code1
                mov     cx,offset S92code1_end
                mov     di,0040h
                sub     cx,si
                mov     dx,1000h-100h
                sub     dx,cx
                push    cx
                call    scan_string
                pop     cx
                jc      No_match
                mov     di,bx
                mov     si,offset S92patch1
           rep  movsb

; patch2
                mov     si,offset S92code2
                mov     cx,offset S92code2_end
;                mov     di,0000h
                sub     cx,si
                mov     dx,1000h-100h
                sub     dx,cx
                push    cx
                call    scan_string
                pop     cx
                jc      No_match
                mov     di,bx   ; 
                mov     si,offset S92patch2
                mov     cx,offset S92patch2_end
                sub     cx,si
         rep    movsb
                clc
                ret
No_match:       stc
                ret
S92_patch       ENDP


;==========================================================================
;  S92 SCSI BIOS ӏR[h ^ ǃR[h
;==========================================================================
S92code1        label   byte
                test    byte ptr [bp+50h],80h  ; DA/UA
                DB      75h
                DB      08h     ; jnz   S92code1_end
                mov     dl,[bp+56h]     ; DL
                mov     ax,[bp+54h]     ;
                DB     0EBh             ; JMP
                DB      24h             ; 
S92code1_end    label   byte

S92patch1       label   byte
                mov     eax,[bp+54h]    ; eax <==[bp+54],[bp+56]
                BSWAP   eax
                nop
                test    byte ptr [bp+50h],80h  ; DA/UA
                DB      74h             ; JZɕύX
                DB      24h+5           ; WvToCgɂ炷
S92patch1_end   label   byte

S92code2        label byte
                mov     al,[bx+01h]    ; head count
                and     al,0Fh         ; 4bit}XN
                xor     ah,ah          ;  wbh<15@
                mov     cx,[bp+54h]    ;
                mul     cx
                add     al,[bp+57h]
                adc     ah,00
                mov     cl,[bx]
                xor     ch,ch
                mul     cx
                add     al,[bp+56h]
                adc     ah,00h
                adc     dx,+00h
                mov     [bp+07h],dl
                mov     [bp+08h],ah
                mov     [bp+09h],al
S92code2_end    label byte

S92patch2       label byte              ; DS= 0;  BX=0460h+ID*4
                mov     al,[bx+01h]             ; AL= BIOSwbh
                and     al,0Fh                  ; 4bit}XN
                movzx   ecx,al                  ; wbhECX
                movzx   eax,word ptr [bp+54h]   ; [bp+54h]V_ԍ
                mul     ecx                     ; Z
                mov     cl,[bp+57h]             ; [bp+57h]wbhԍ
                add     eax,ecx                 ; Z
                mov     cl,byte ptr [bx]        ; CL= BIOSZN^
                mul     ecx                     ; Z
                mov     cl,byte ptr [bp+56h]    ; [bp+56h]ZN^ԍ
                add     eax,ecx                 ; Z EAX jAAhX
                BSWAP   eax
                nop
                mov      [bp+06h],eax            ;
S92patch2_end   label byte

.386
;--------------------------------------------------------
;   PCI_9821Check ( by system work area )  F8E8:0004, bit 5
;--------------------------------------------------------
PCI_9821Check   PROC    near
                mov     MachineID,0FEh
                mov     bx,0F8E8h
                mov     ah,00h
                test    flagset,F_HIRESO
                jz      @f
                mov     bx,0FFE8h
                mov     ah,80h
        @@:     
                push    ds
                mov     ds,bx
                mov     dx,ds:[0000h]
                mov     al,ds:[003Fh]
                mov     bl,ds:[0004h]
                pop     ds

                cmp     dx,2198h
                jne     Not9821
;;;;;;;;;       or      flagset,F_9821
                test    bl,00100000b
                jz      @f
;;;;;;;;;       or      flagset, F_PCI
                jmp     PCI_9821
        @@:
                or      al,ah
                mov     MachineID,al
Not9821:
                clc
                RET
PCI_9821:       stc
                ret
PCI_9821Check   ENDP

;================================================== DATA END =============
align   16
DataSegment     label word
DD      4 dup  (0)
code    ends
        end     start

