;---------------------------------------------------------------------------
;       EnvCheckH98     (H98)
;---------------------------------------------------------------------------
EnvCheckH98     PROC   near
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     al,byte ptr ds:[0458h]      ; H98 flag = bit7
                mov     ah,byte ptr ds:[0501h]      ; hireso flag =bit 3
                pop     ds
                and     al,80h  ; bit 7
                jnz     @f
                stc
                ret
        @@:     
                mov     SegSCSIBIOS,  0D000h
                mov     SegSCSIBIOS_E,0DE00h
                mov     PortROMRAM, 098D1h
                mov     PortMask, 00000011b
                test    ah,8
                jz      H98Normal
                mov     SegSCSIBIOS,  0E800h
                mov     SegSCSIBIOS_E,0EE00h
                mov     PortROMRAM, 098D3h
                mov     PortMask, 00110000b
H98normal:      clc
                ret
EnvCheckH98     ENDP

.386
;--------------------------------------------------------
;       H98model105
;--------------------------------------------------------
H98_machine:    mov     dx,offset H98m105_msg     
                call    _puts

                push    ds
                mov     ds,SegPhysSCSIBIOS
                mov     es,SegTempMem
                PrepMemMove     2000h
                pop     ds

                mov     es,SegTempMem
                call    ScanSCSIBIOS8K
                jc      B12_notfound    ; p^[ȂΏI
                call    Patch_B12_105   ; PC-H98 model105 B12 patch
B12_notfound:   ; B12 m105SCSI BIOSĂȂĂ
                jmp     EndJob          ; C̍Ōɖ߂iCM[j

;---------------------------------------------------------------------------
;       ScanSCSIBIOS8K    (H98)
;---------------------------------------------------------------------------
ScanSCSIBIOS8K  PROC   near
                xor     eax,eax
                mov     dx,SegSCSIBIOS
SCSI_BIOS_ent:  
                push    es
                mov     es,dx
                mov     eax,es:[0008h]
                pop     es
                cmp     eax,02AA5590h   ; SCSI BIOS 
                jz      SCSI_BIOS_found
                add     dx,0200h
                cmp     dx,SegSCSIBIOS_E
                Jbe     SCSI_BIOS_ent
                mov     dx,offset absentH98_msg
                stc
                ret
SCSI_BIOS_found:
                mov     SegSCSIBIOS,dx
                clc
                ret
ScanSCSIBIOS8K  ENDP

;-------------------------------------------------------------
;       Patch_B12_105   H98model105SCSI BIOSւ1GBpb`
;-------------------------------------------------------------
Patch_B12_105   PROC   near
                mov     dx,043Fh        ; LbṼtbV
                mov     al,0A0h         ; H98łł̂킩Ȃ
                out     dx,al
                jmp     $+2

                mov     es,SegSCSIBIOS  ; E10PAT 2020-3-20 1.51Œǉ
                call    S92_patch    ; Pڃpb`ł͏ςȂ
                jc      B12_notfound    ; p^[Ȃ΃Wv
                
                pushf   ; ɗƂ͌Ă
                cli
                mov     dx,PortROMRAM   ; Write Protect
                in      al,dx
                mov     temp,al
                or      al,PortMask
                out     dx,al

                mov     es,SegSCSIBIOS  ; Qڃpb` 2020-3-20 1.51
                call    S92_patch    
                jc      H98SCSI_notfound    ; G[ɂ͂ȂȂ͂

                mov     ah,PortMask     ; Write Protectɖ߂
                not     ah
                mov     dx,PortROMRAM
                mov     al,temp
;;;;;;;         and     al,ah
                out     dx,al
                popf
                mov     dx,offset PatchedB12BIOS
                call    _puts
                jmp     Patch_105_end
H98SCSI_notfound: 
Patch_105_end:
                mov     dx,043Fh
                mov     al,0A0h         ; LbṼtbV
                out     dx,al           ; H98łł̂킩Ȃ
                jmp     $+2
                ret
Patch_B12_105   ENDP

;-----------------------------------------------------------
;       CheckEPSON
;-----------------------------------------------------------
CheckEPSON      PROC   near
                xor     ax,ax
                mov     es,ax
                mov     ax,0FD80h       ; seg
                mov     bx,0002h        ; ofs
                mov     cx,2A27h        ; EPSON 27h,2Ah (Normal)
                test    byte ptr es:[0501h],8
                jz      EpsonNormalMode
                mov     ax,0F800h       ; seg
                mov     bx,07F70h       ; ofs
                mov     cx,1827h        ; EPSON 27h,18h (Hireso)
EpsonNormalMode:  
                mov     es,ax
                cmp     es:[bx],cx      ; compare
                je      IsEPSONPC
                clc
                ret
IsEPSONPC:      
                mov     al,es:[3]       ; EPSON ID
                mov     ah,0
                stc     ; CY=EPSON PC
                ret
CheckEPSON      ENDP


.186
