ROMWARE       equ   1
CBUS_BD_ID    equ  02h  ; SCSIƓɂ(V1.00)
;-----------------------------------------------------------------------------
;  hireso-100 ROM 1.00  (C) 2025 DOSsoft
;-----------------------------------------------------------------------------
code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
ifdef  ROMWARE
                org 0h
  include btromhdr.inc
ELSE
                org 100h
  start:        jmp     MAIN
ENDIF

ProgramTitle    DB  "HIRESO-100  V1.00 with 'div0rom' (C) 2025 ",0
include  vars.inc    ; u[gROMwb_㏈
.286
MAIN:   ; ܂ROMCSim[} D000, nC]EA00jŎsĂ
                enter   28h,0           ; CS̓
                mov     ah,03h  ; L[{[hBIOSinC]ŕKv炵j
                int     18h
                mov     cx,4321h  ; ԑ҂
        @@:     out     5Fh,al
                out     5Fh,al
                mov     ah,2    ; VtgL[ރZX@\
                int 18h
                test    al,00010000b    ; 16=CTRLĂ
                jnz     NoMessegeExit   ; ƂSsi\j
               loop     @b

                mov     COLUMN,0
                mov     ROW,5
                mov     SegData100, 0DC00h      ; ɂ̃AhX
.286
                call    CheckResoMode   ; nC][ĥƂ̕ϐ
                call    GetDisplayLine
                call    TextGreen
                
                mov     dx,offset ProgramTitle
                call    _puts
                mov     dx,offset signature
                call    _puts_DB_CS
                mov     dx,offset machine_is
                call    _puts_DB_CS
                call    CheckEnv21PCI
                mov     dx,offset err_invalid
                jc      ErrExit
                call    AmateType
                call    PeriEnvCheck    ; IDE BIOS͏oĂ̂ƂĂ

                test    flagset,F_HIRESO        ; nC][ĥƂ
                mov     dx,offset err_normal_mode
                jz      ErrExit

StartHireso:  ; nC][hŎs镔
                call    Copy100ROM_TEMP ; hidden DC000-> 7C000 Rs[

                call    Check100ROM
                mov     dx,offset err_100board
                jc      ErrExit

                or      flagset,F_SUCCESS
                call    GetShadowRAM    ; 7C000 -> 8A000(EA000) Rs[
                
                test    flagset, F_SUCCESS
                jz      ExitProgram
                mov     dx,offset Successfully
                call    _puts_DB_CS
ExitProgram:    
                mov     al,00h
                jmp     NoMessegeExit

ErrExit:        call    _puts_DB_CS
                mov     COLUMN,61
                dec     ROW
                mov     ATTRIB,0A1h
                mov     dx,offset err_abort
                call    _puts_DB_CS
NoMessegeExit:  
                mov     bx,04DCh
                mov     ax,0DC00h
                test    flagset, F_HIRESO
                jz      @f
                test    flagset, F_SUCCESS
                jz      @f
                mov     bx,04C4h        ; High resolution mode
                mov     ax,0EA00h       ; return
        @@:
                leave
                RET
;===================================================
AmateType       PROC   near
                mov     Out467Val,2
                mov     al,MachineID
                mov     dx,offset pc9821ap3
                cmp     al,18h
                je      a_mate3
                cmp     al,84h
                je      a_mate3

                mov     dx,offset pc9821an
                cmp     al,0Dh
                je      a_maten
                cmp     al,83h
                je      a_maten

                mov     dx,offset pc9821af
                cmp     al,05h
                je      a_mate2
                cmp     al,06h
                je      a_mate2
                cmp     al,82h
                je      a_mate2
                cmp     al,81h
                je      a_mate2
                mov     dx,offset pc9821a1
                cmp     al,80h
                je      a_mate1
                or      al,al
                jz      a_mate1
a_maten:        call    _puts
                mov     dx,045Fh    ; shrink wait
                mov     al,4Fh
                out     dx,al
                mov     dx,0432h    ; Fast IDE
                mov     al,12h
                out     dx,al
                ret
a_mate1:
a_mate2:        call    _puts
;;;;;;;         call    IDE543MB
                ret
a_mate3:        
                call    _puts
                or      Out467Val,0D2h
                call    EnableWB
                ret
AmateType       ENDP

;----------------------------------------------
EnableWB        PROC   near
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     ax,ds:[0486h]
                pop     ds
                cmp     ax,04F4h        ; Am5x86 WB x4 speed
                je      start_WB
                cmp     ax,0494h        ; Am5x86 WB x3 speed 
                je      start_WB
                cmp     ax,0490h        ; WBE DX4-100 SK096 (fixed on Dec.2022)
                je      start_WB
                and     ax,0F00h
                cmp     ax,0500h
                jb      NotPentium
                mov     dx,045Fh
                mov     al,4Fh
                out     dx,al
NotPentium:     ret
start_WB:       mov     dx,063Fh
                in      al,dx
                or      al,10000000b
                out     dx,al
                ret
EnableWB        ENDP
;-------- I-----------------------------------
Copy100ROM_TEMP PROC   near     ; DC000-->SegTemp(7C00):0000
                mov     dx,043Fh ; 
                mov     al,0A0h   ; clear cache 
                out     dx,al

                DB      2Eh
        rep     movsb
                mov     AL,0CBh ; = RETF code
                stosb

                xor     ax,ax
                mov     si,ax
                mov     di,ax
                mov     es,SegTemp      ; stack
                mov     cx,4000h/2

                out     50h,al

                pushf
                cli
                mov     dx,0EAAh
                mov     al,1
                out     dx,al   ; őSVRAM؂藣boXɐڑ

                mov     dx,0467h
                mov     al,00h
                out     dx,al   ; boXɃm[}[hʒmA{[h\

                mov     ds,SegData100   ; = DC00 stack var.
                push    ds
        rep     movsw
                pop     ds
                
                mov     dx,0EAAh
                mov     al,0
                out     dx,al   ; SVRAM𕜌

                mov     dx,0467h
                mov     al,Out467Val
                out     dx,al   ; boXɃnC][hʒm@Ԃ𕜌

                popf    ; (sti)

                mov     dx,043Fh ; 
                mov     al,0A0h   ; clear cache 
                out     dx,al
                out     52h,al
                ret
Copy100ROM_TEMP ENDP

;--------------------------------------------------
;--------------------------------------------------
GetShadowRAM    PROC   near
                mov     BL,AH
                mov     dx,053Dh
                mov     al,equip
                or      al,0C2h
                test    flagset, F_HIRESO
                jz      @f
                or      al,02h
        @@:
                out     dx,al
                call    CopyRAM
                RET
GetShadowRAM    ENDP
;--------------------------------------------------
FillRAM         PROC   near
                mov     dx,043Fh ; 
                mov     al,0A0h   ; clear cache 
                out     dx,al

                mov     cx,4000h/2
                sub     di,di
                mov     es,SegMMap100BIOS

                mov     dx,MemBankIOAddr
                mov     al,0Eh
                out     dx,al

                xor     ax,ax
        rep     stosw
                mov     dx,MemBankIOAddr
                mov     al,MemWindowNative
                out     dx,al

                mov     es,SegPhys100BIOS
                xor     ax,ax
                mov     di,ax
                mov     cx,4000h/2
        rep     scasw
                jcxz    @f
                stc
                ret
        @@:     clc
                ret
FillRAM         ENDP
;--------------------------------------------------
.386
CopyRAM         PROC   near
                mov     dx,043Fh ; 
                mov     al,0A0h   ; clear cache 
                out     dx,al

                mov     cx,4000h/2
                sub     di,di
                mov     si,di
 
                push    ds
;                mov     ds,SegData100
                mov     ds,SegTemp
                mov     es,SegMMap100BIOS

                mov     dx,MemBankIOAddr    ; 461h/91h
                mov     al,0Eh
                out     dx,al
        rep     movsw
                mov     dx,MemBankIOAddr    ; 461h/91h
                mov     al,MemWindowNative  ; 08h or 10h
                out     dx,al

                pop     ds

                RET
CopyRAM         ENDP
;--------------------------------------------------
;----------------------------------------------------
Check100ROM     PROC   near
                mov     es,SegTemp
                mov     eax,es:[00h]
                cmp     eax,0CB9090CBh
                jne     Check100ROM_fail
                mov     eax,es:[08h]
                cmp     eax,02AA5590h
                jne     Check100ROM_fail
                mov     eax,es:[30h]
                cmp     eax,504E5024h
                jne     Check100ROM_fail
                clc
                RET
Check100ROM_fail:
                stc
                RET
Check100ROM     ENDP
;--------------------------------------------------

include  sub.inc
;--------------------------------------------------
;include  j:\exide\543\patcode.s
;include  ide543.inc
;--------------------------------------------------
if 0
align 16
                DB      14 dup(0)
CHKSUM_00       DB      0
CHKSUM_01       DB      0
endif
OnMemoryCode_end        label word
;        DB      4000    dup (0FFh)
;org     1000h
code    ends
        end     start
