;--------------------------------------------------------
;       MEMtoIDEBIOS    5C00:0-->D800:0
;--------------------------------------------------------
MEMtoIDEBIOS    PROC   near
                pushf
                cli                     ; BIOSRAMւ̓]͊荞݋֎~Ƃ
                call    ROMRAM486_IDE   ; ݒALbVtbV
                call    MEMtoROM        ; MEM̃f[^RAMBIOSɃRs[
                call    RAMROM486_IDE   ; sݒALbVtbV
                popf
                ret     ; G[Ԓl͂Ȃ
MEMtoIDEBIOS    ENDP

;--------------------------------------------------------
;       MEMtoROM        5000:0-->ES:0   ES=RAMwindowIDE
;--------------------------------------------------------
MEMtoROM        PROC    near
                cld
                mov     es,SegMMapIDEBIOS
                mov     cx,2000h/2      ; 8KB
                push    cx
                xor     ax,ax
                mov     si,ax
                mov     di,ax
                push    si
                mov     ax,MEMseg
                push    ds
                mov     ds,ax   ; ds=MEMseg, es=IDE BIOSRAMwindow
           rep  movsw
                pop     ds
                pop     si
                pop     cx
                ret
MEMtoROM        ENDP

;--------------------------------------------------------
;       ROMtoMEM        ds=D800:0-->5000:0
;--------------------------------------------------------
ROMtoMEM        PROC    near
                cld
                mov     cx,2000h/2      ; 8KB
                xor     ax,ax
                mov     si,ax
                mov     di,ax
                mov     ax,MEMseg
                push    es
                push    ds
                mov     es,ax   ; ES=AX=MEMseg
                mov     ds,SegPhysIDEBIOS   ; DXɐ^IDE BIOS̃ZOg
          rep   movsw
                pop     ds
                pop     es
                ret
ROMtoMEM        ENDP

;--------------------------------------------------------
;       ROMRAM486_IDE  (ex)     A-mate
;--------------------------------------------------------
ROMRAM486_IDE   PROC    near
                mov     dx,043Fh ;
                mov     al,0A0h   ; clear cache
                out     dx,al
                mov     dx,mem_bank_IOaddr      ; 8-9 bank selected to
                mov     al,MemWindowAddr        ; address C000 or E000h.
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,02h   ; RAM window access enable =bit2=0
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                ret
ROMRAM486_IDE   ENDP
;--------------------------------------------------------
RAMROM486_IDE   PROC    near
                mov     dx,mem_bank_IOaddr      ; 8-9 bank selected to
                mov     al,MemWindowNative      ; address 8000h or 10000h
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,06h   ; RAM window access disable =bit2=1
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                mov     dx,043Fh ;
                mov     al,0A0h  ; Invalidate CPU cache
                out     dx,al
                ret
RAMROM486_IDE   ENDP
