title_mactype   DB      0E1h,"@ ",0
machine_typeC2  DB      0E1h,"98Multi PC-9821Cs2,Ce2 ",0
machine_typeB2  DB      0E1h,"PC-9801BX2,BA2, 9821Be,Bs,Be ",0
machine_typeA2  DB      0E1h,"PC-9821 Ap2,As2,Af ",0
machine_typeA1  DB      0E1h,"PC-9821Ap,As,Ae ",0
IDE_msg         DB     0E1h,"  IDE BIOSo.  ",0
absent_msg      DB      041h,"  IDE BIOSoĂ܂ifXN̐ڑj",0
msg_sound_bios  DB      0E1h," SOUND BIOSL. ",0
wrong_bios      DB     0C1h,"ΉȂBIOSł. ",0
wrong_msg       DB     041h,"  ̋@ɂ͑Ή܂.",13,10,0
msg_AvoidPatch  DB     0E5h," pb`𒆎~܂. ",13,10,0
msg_CRLF        DB     0E1h," ",13,10,0
msg_div0        DB     0C1h,"DIV0ROM[h[F6]ɐݒ肳Ă̂, EXIDE𒆎~܂.",13,10,0

;------------------------------------------------------------
;       ResoModeCheck   ŏɂP񂾂Ăяo`FbN
;------------------------------------------------------------
ResoModeCheck   PROC    near
                mov     MemWindowAddr,0Ch
                mov     MemWindowNative,08h
                mov     mem_bank_IOaddr,0461h
                xor     ax,ax
                mov     flagset,al
                mov     equip,al        ; bit̏l
                mov     MachineType,al  ; =0
                push    ds
                mov     ds,ax
                mov     al,ds:[0501h]           ; hi-reso check
                pop     ds
                and     al,8    ; 1000b           1      0
                shr     al,2    ;   10b                  0
                add     MemWindowAddr,al        ; 0Eh    0Ch
                shr     al,1    ;    1b
                or      flagset,al      ; flags
                mov     SegTVRAM,0A000h ; Text VRAMZOg
                mov     bx,0F8E8h       ; Machine ID i[ZOg(BIOS)
                mov     ah,00h          ; AH bit 7MAchine ID̈ꕔɎg
                or      al,al
                jz      NormalResoMode  
; HIRESOLUTION MODE SETTINGS
                mov     mem_bank_IOaddr,0091h ; Hireso mem-window port
                mov     MemWindowNative,10h;  Hireso mem-window native addr
                mov     SegTVRAM,0E000h ; The segment of Text VRAM at H mode
                mov     bx,0FFE8h       ; The segment of Machine ID flag at H.
                mov     ah,80h          ; bit7=1 , Machine IDmnC]rbg
NormalResoMode: 
                push    ds
                mov     ds,bx
                xor     bx,bx
                mov     dx,ds:[bx]
                mov     al,ds:[bx+3Fh]
                mov     bl,ds:[bx+04h]
                pop     ds
                cmp     dx,2198h
                je      @f
                mov     al,0FFh
ResoModeCheck_err:
                stc
                ret
        @@:
                or      al,ah           ; nC]bitƍ
                mov     MachineID,al
                test    bl,00010000b
                jz      @f
                or      flagset,F_PCI
                jmp     ResoModeCheck_err
        @:
                clc
                ret
ResoModeCheck   ENDP



;--------------------------------------------------------
;       SetTone         
;--------------------------------------------------------
SetTone         PROC   near             ; ax= tone
                push    dx
                mov     DX,03FDBh       ; 3FDB
                out     DX,AL
                out     5Fh,al
                xchg    AL,AH
                out     DX,AL
                out     5Fh,al
                pop     dx
                ret
SetTone         ENDP

;--------------------------------------------------------
;       GetDisplayLine
;--------------------------------------------------------
GetDisplayLine  PROC    near
                xor     ax,ax
                mov     COLUMN,ax
                push    ds
                mov     ds,SegTVRAM
                mov     ROW,MSG_DISP_LINE
                mov     al,ds:[3FE0h]   ; ITF\sǗAhX
                pop     ds
                cmp     al,MSG_DISP_LINE
                ja      LineIndicatorInvalid
                inc     ax
                mov     ROW,ax
LineIndicatorInvalid:
                mov     ax,ROW
                mov     StartLine,al
                ret
GetDisplayLine  ENDP

;--------------------------------------------------------
;       SetDisplayLine  
;--------------------------------------------------------
SetDisplayLine  PROC   near
                mov     ax,ROW
                push    ds
                mov     ds,SegTVRAM
                mov     ds:[3FE0h],al    ; [ITF\sǗAhX]
                pop     ds
                ret
SetDisplayLine  ENDP

;--------------------------------------------------------
;       ShiftKeyCheck
;--------------------------------------------------------
ShiftKeyCheck   PROC    near
LoopPressShift: mov     ah,02h
                int 18h
                test    al,00010001b    ; 1=SHIFT, 8=GRPH, 16=CTRL
                jnz     LoopPressShift
                ret
ShiftKeyCheck   ENDP


;--------------------------------------------------------
;       Exist_IDE_BIOS
;--------------------------------------------------------
Exist_IDE_BIOS  PROC   near
                push    es
                mov     es,SegPhysIDEBIOS
                mov     ax,es:[0009h]   ; ? C-BUS ROM
                mov     bx,es:[000Bh]   ; ? C-BUS ROM
                pop     es
                cmp     ax,0AA55h       ; C-BUS ROM signature
                jnz     NoExist_IDE_BIOS
                cmp     bl,2Ah          ; C-BUS ROM type ID
                jnz     NoExist_IDE_BIOS
                mov     dx,offset IDE_msg ; uIDE BIOS܂v
                call    _puts
                clc
                ret
NoExist_IDE_BIOS:  
                mov     dx,offset absent_msg
                call    _puts
                stc
                ret
Exist_IDE_BIOS  ENDP

;---------------------------------------------------------------------
;       Get segment address of IDE BIOS   ɂP񂾂R[
;---------------------------------------------------------------------
GetSeg_IDEBIOS  PROC    near
                xor     ax,ax
                push    ds
                mov     ds,ax
                mov     al,ds:[0457h]
                mov     ah,ds:[05B0h]
                pop     ds
;;;;;;;;;;;;    mov     WORK0457,al
;;;;;;;;;;;;    mov     WORK05B0,ah
                test    flagset,F_HIRESO   ; --- Normal mode ---
                mov     cx,0DA00h   ; IDE work address (physical)
                mov     dx,0D800h   ; IDE BIOS address (physical)
                mov     ax,09800h   ; IDE BIOS address of memory window
                jz      NormalMode_IDE
                mov     cx,0E800h   ; IDE work address (physical)
                mov     bx,0E600h   ; IDE BIOS address (physical),ordinary
                mov     dx,063Dh
                in      al,dx
                test    al,2
                jz      @f
;;;             add     OffsetXcode,2000h       ; using adapter 
                mov     cx,0EA00h   ; IDE work address (physical)
        @@:     mov     dx,bx       ; 
                sub     bx,6000h    ; phisycal --> shadow
                mov     ax,bx       ; IDE BIOS address of memory window
NormalMode_IDE: mov     SegPhysIDEBIOS,dx
;                mov     SegPhysIDEwork,cx
                mov     SegMMapIDEBIOS,ax
;                mov     es,ax
                ret
GetSeg_IDEBIOS  ENDP

;--------------------------------------------------------------------
;       scan_pattern     ̔r[`  for IDE BIOS (type 2)
;       <input>
;       DS:SI rp^[,         CX p^[̃oCg
;       ES:DI p^[ꏊ,         DX ͈̔̓oCg
;       <output>        < j AX,BX,CX,DX,DI >
;       CY =NONE ,  NC= ES:BX   carry0̂Ƃ  ES:BXɌoꏊԂ
;--------------------------------------------------------------------
scan_pattern    PROC    near
                cld
                mov     di,0030h
                sub     cx,si   ;<-------- type 2
                mov     dx,2000h-30h
                sub     dx,cx   ;<-------- type 2

                xor     bx,bx
                add     dx,di
scan_ent:       mov     ax,ds:[si]
                cmp     ax,es:[di]
                jnz     scan_No_match

                mov     bx,di
                push    cx
                push    si
                push    di
         repz   cmpsb
                or      cx,cx
                pop     di
                pop     si
                pop     cx
                jnz     scan_No_match
                clc                     ; scan OK
                ret
scan_No_match:  inc     di
                cmp     di,dx
                jb      scan_ent
                stc                     ; scan NG
                ret
scan_pattern    ENDP

;---------------------------------------------------------
;       Beep Tone98Set
;---------------------------------------------------------
Tone98Set       PROC    near
                push    dx
                mov DX,03FDBh        ; 3FDB
                out DX,AL
                out     5Fh,al
               xchg AL,AH
                out DX,AL
                out     5Fh,al
                pop     dx
                ret
Tone98Set       ENDP
;--------------------------------------------------------
;--------------------------------------------------------
BeepSound       PROC   near
                call    Tone98Set
                mov     al,6            ; BEEP ON
                out 37h,al              
                mov     cx,bx
        @@:     out     5Fh,al  ; ҂
                out     5Fh,al
               loop     @b
                mov     al,7            ; BEEP OFF
                out 37h,al              
                mov     ax,04CDh        ; normal freq.
                call    Tone98Set
                ret
BeepSound       ENDP
;--------------------------------------------------------
;       Poop
;--------------------------------------------------------
Poop            PROC   near
                push    ax
                push    dx
                push    cx
                push    bx
                mov     ax,4000
                mov     bx,6543h 
                call    BeepSound
                pop     bx
                pop     cx
                pop     dx
                pop     ax
                ret
Poop            ENDP
;--------------------------------------------------------
;       Peee
;--------------------------------------------------------
Peee            PROC   near
                push    ax
                push    dx
                push    cx
                push    bx
                mov     ax,3000
                mov     bx,0FFF0h 
                call    BeepSound
                pop     bx
                pop     cx
                pop     dx
                pop     ax
                ret
Peee            ENDP

;--------------------------------------------------------
;       ClearMEMseg
;--------------------------------------------------------
ClearMEMseg     PROC    near
                push    es
                mov     cx,2000h/2
                mov     ax,MEMseg
                mov     es,ax
                xor     ax,ax
                mov     di,ax
           rep  stosw
                pop     es
                ret
ClearMEMseg     ENDP

;--------------------------------------------------------
;       DisplayTitle  ( Gen.2p )
;--------------------------------------------------------
DisplayTitle    PROC    near
                mov     dx,offset title_msg
                call    _puts
                RET     
DisplayTitle    ENDP


IF 1
;--------------------------------------------------------
;       SetChkSum        ES:0   ES=RAMwindowIDE
;--------------------------------------------------------
SetChkSum       PROC    near
                mov     ax,MEMseg
                push    ds
                mov     ds,ax
                xor     dx,dx
                mov     si,dx
                mov     cx,(2000h/2)
                dec     cx
        @@:
                lodsw
                add     dl,al
                add     dh,ah
               loop     @b
                neg     dl
                neg     dh
                mov     ds:[si],dx
                pop     ds
                ret
SetChkSum       ENDP
ENDIF

;------------------------------------
;       Erase1Line
;------------------------------------
Erase1Line      PROC   near
                push    ROW
                mov     COLUMN,0
                push    ax
                mov     es,SegTVRAM ; ̕ϐ͊OIɊm肳Ă̂Ƃ
                mov     ax,80       ; Ps80
                mul     ROW         ; ̕ϐ͊OIɊm肵Ă̂Ƃ
                add     ax,COLUMN   ; ̕ϐ͊OIɊm肵Ă̂Ƃ
                shl     ax,1        ; VRAMAhXł2{
                mov     di,ax       ; DI=ɕ\JnʒuItZbgi[
                mov     ax,0020h    ; space code on VRAM
                mov     cx,80
        @@:     mov     byte ptr es:[di+2000h],0E1h
                stosw
               loop     @b
                pop     ax
                pop     ROW
                ret
Erase1Line      ENDP
;===================================
