;;;INICOM equ 1
;----------------------------------------------------------------------------
; PC-9821B2 IDE BIOS patch Version 5.30E (C) 2024-2025 ܂
;----------------------------------------------------------------------------
LOCATION_CHSLBA equ     1D70h   ; Ƃ̂Ɏ܂ȂR[h̊i[ꏊ
LOCATION_LBACHS equ     10F0h   ; ubNXgׂĂ
LOCATION_IDP    equ     1E65h   ; IDE BIOS̋󂫂͎gȂ悤ɂ
LOCATION_FUNC84 equ     10B7h   ; 
LOCATION_CAPA   equ     1DB0h   ; Ƃ̂Ɏ܂ȂR[h̊i[ꏊ
LOCATION_SET66  equ     1FB0h

CylnN           equ     es:[si+02h]
Dev_HS_MUL      equ     es:[si+08h]
DevSectN        equ     es:[si+0Ah]
DevHeadN        equ     es:[si+0Bh]
HS_MUL          equ     es:[si+0Ch]
SectN           equ     es:[si+0Eh]
HeadN           equ     es:[si+0Fh]

include vars.inc

code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:
                jmp     program_start
                DB      01h
title_msg       DB      0E1h,"IDE BIOS̗eʏgCHSύXmANTI-CFؾānIDE BIOS Qp  V5.30E",13,10,0
msg_not_for_A2  DB      041h,"PC-9821 Ap2,As2,Afɂ͑Ή܂. ",0
machine_typeUN  DB      0E1h,"QłȂ  ",0

.186
program_start:  
                enter   40,0
                mov     COLOR_ATTRIB,0E1h
                cld
                call    ResoModeCheck   ; nC]^m[}`FbNT-VRAMZOg擾
                call    GetSeg_IDEBIOS  ; ^,RAMIDE BIOSZOg𓾂 2018-12-11V
                call    GetDisplayLine  ; ITF TEXTʕ\s̐ݒ
                call    DisplayTitle    ; ^Cg\
                call    CheckDIPSW25
                call    Scan_GRPH_FK
                jc      CancelCTRL

                call    ModelCheckAB2   ; @풲, B2,C2ȊO͒~(A2́H)
                jc      WrongMachine
                call    PeriEnvCheckB   ; 486@ƔfROM`FbN
                jc      ExitProgram     ; CY=G[Œ~

                call    Exist_IDE_BIOS  ; IDE BIOS̑݃`FbN
                jc      ExitProgram     ; CY=G[Œ~
                mov     dx,offset msg_CRLF
                call    _puts

                call    CheckMemSwitch  ; XCb`̃[hݒ擾
                jc      ExitProgram     ; CY=G[ŏI

                call    ROMtoMEM        ; IDE BIOS ROMMEMɓ] 8KB
                call    B2_patch        ; B2@̃pb`
                jc      WrongBIOS
                call    SetChkSum
                call    MEMtoIDEBIOS    ; ̍ƌʂRAM BIOSɃRs[
                call    ClearMEMseg     ; ƃNAđދ
ExitProgram:
                call    ShiftKeyCheck   ; VtgL[ŕ\ꎞ~
                call    SetDisplayLine
                leave
                RET    ; near ^[ŏI
;-------------------------------------------
WrongMachine:   mov     dx,offset wrong_msg 
                call    _puts   ; ű@ɂ͑ΉĂ܂v\
                jmp     ExitProgram     ; G[ŏI
CancelCTRL:     mov     dx,offset msg_CRLF
                call    _puts
                jmp     AvoidPatch
WrongBIOS:      call    Poop ; ```
                mov     dx,offset wrong_bios    ; uΉBIOSł͂Ȃv
                call    _puts
AvoidPatch:     mov     dx,offset msg_AvoidPatch; u~܂v 
                call    _puts
                jmp     ExitProgram

;--------------------------------------------------------

;--------------------------------------------------------
;       machines
;--------------------------------------------------------
include patch_b2.inc
;;include ..\AP2\patch_A2.inc

;-----------------------------------------------------------------------
PeriEnvCheckB   PROC   near ; SASI BIOSׂ͒ȂiDISKڑUNITgp֎~j
                in      al,0F0h
                OR      equip,IDE_equip ; IDE BIOS o
                test    flagset, F_HIRESO  ; nC]Ȃ疳
                jnz     @f              ; SOUND BIOS݂͑ȂƂ
                mov     dx,841Eh        ; DIP switch 𒲂ׂɍs@g
                in      al,dx           ; Ap,As,Aeł͕ʂ̌o@I
                test    al,02h          ; bit 1: Undoc2 ƈႤ̂Œ
                jz      EndCheckSoundBIOS
                or      equip,SND_equip ; TEhBIOSL
                mov     dx,offset msg_sound_bios
                call    _puts
EndCheckSoundBIOS:
                clc
                ret
        @@:     stc
                ret
PeriEnvCheckB   ENDP


;------------------------------------------------------------
;       ModelCheckAB2
;------------------------------------------------------------
ModelCheckAB2   PROC   near
                mov     dx,offset title_mactype
                call    _puts
                mov     al,MachineID
                cmp     al,07h  ; Bp,Bs,Be,PC-9801 BX2,BA2
                je      MachineTypeB2
                cmp     al,08h  ; Ce2,Cs2
                je      MachineTypeC2
                cmp     al,05h ; Ap2,As2
                jne     NotB2
                cmp     al,06h ; Af
                jne     NotB2
                mov     dx,offset machine_typeUN
NotB2C2:        call    _puts
                stc
                ret
NotB2:          mov     dx,offset msg_not_for_A2
                jmp     NotB2C2
MachineTypeB2:  mov     MachineType,3
                mov     dx,offset machine_typeB2
                jmp     @f
MachineTypeC2:  mov     MachineType,2
                mov     dx,offset machine_typeC2
        @@:     call    _puts
                clc
                ret
ModelCheckAB2   ENDP

;----------------------------------------------
;--------------------------------------------------------
;       CheckDIPSW25  Q`R  in al,31h
;--------------------------------------------------------
CheckDIPSW25    PROC   near
                mov     dx,871Eh
                in      al,dx
                test    al,00100000b
                jz      @f
                or      flagset,F_MEMSW_INI
                inc     StartLine
        @@:     ret
CheckDIPSW25    ENDP
if 0
DisplayEquip    PROC   near
                push    ROW
                push    COLUMN
                mov     al,StartLine
                mov     ah,0
                inc     ax
                mov     ROW,ax
                mov     COLUMN,56
                mov     dx,offset msg_sound_bios
                call    _puts
                pop     COLUMN
                pop     ROW
                ret
DisplayEquip    ENDP
endif
;------------------------------
include memcopy.inc
include ideptcom.inc
include setmode6.inc
include numeric.inc     ; l\[`
include e:\asmlib\putstrCS.inc      ; \[`i\[X͕t܂j
;-----------------------------------------
;;include ..\AP2\patch5A2.inc

.386
PatPtn2_LBA_CHS    label word      ; offset 0A66h
                mov     si,2080h
                test    byte ptr [bp+00h],01h
                jz      @f
                mov     si,2090h
        @@:     
                push    ax
                mov     ax,es:[si+0Ah]  ; ZN^ ,wbh
                mul     ah
                mov     cx,ax           ; ZN^*wbh=CX
                pop     ax              ; DX:AX

                div     cx
                mov     es:[2002h],ax
                mov     ax,dx
                mov     cl,es:[si+0Ah]
                mov     ch,0
                mov     dx,0
                RET
PatPtn2_LBA_CHS_end  label word
;--------------------------------------
.186
;--------------------------------------
;  W    [2082h]    CylnN(BIOS,logical)
;  B    [208Ah]    SectN(device,physical)
;  B    [208Bh]    HeadN(device,physical)
;          9
;  B    [208Eh]    SectN(BIOS,logical)
;  B    [208Fh]    HeadN(BIOS,logical)

PatPtn2_IDP     label word      ; offset 1DC0
                test    byte ptr [bp+00h],01h
                jz      Drive00
Drive01:        mov     byte ptr ah,es:[2090h+0Bh]
                dec     ah      ;phys head-1
                and     al,07h
                cmp     al,04h
                jmp     LAB_39A
Drive00:        mov     byte ptr ah,es:[2080h+0Bh]
                dec     ah      ;phys head-1
                and     al,38h
                cmp     al,20h
LAB_39A:
                jnz     LAB_3A5
                or      byte ptr es:[2004h],ah
                jmp     LAB_3AB
                nop
LAB_3A5:
                or      byte ptr es:[2004h],ah
LAB_3AB:
                RET
PatPtn2_IDP_end  label word
;----------------------------------
PatPtn2_Func84  label word      ; offset 03E1h
                push    ax
                mov     si,2080h
                test    byte ptr [bp+00],01h
                jz      @f
                mov     si,2090h
        @@:
                mov     al,es:[si+0Eh]  ; S
                mov     [bp+06h],al
                mov     al,es:[si+0Fh]  ; H
                mov     [bp+07h],al
                mov     dx,es:[si+02h]  ; C
                mov     [bp+04h],dx
                pop     ax
                ret
PatPtn2_Func84_end  label word

;----------------------------------
DB      0,0,0,0,0,0,0,0,0,0,0,0,0,0
DB      "ROM̕E̔ւ܂. (C)2025",0,0
code    ends
        end     start
