;----------------------------------------------------------------------------
; PC-9821Ap2 IDE BIOS patch Version 5.30F (C) 2025/10/24 ܂
;----------------------------------------------------------------------------
CylnN           equ     es:[si+02h]
Dev_HS_MUL      equ     es:[si+08h]
DevSectN        equ     es:[si+0Ah]
DevHeadN        equ     es:[si+0Bh]
HS_MUL          equ     es:[si+0Ch]
SectN           equ     es:[si+0Eh]
HeadN           equ     es:[si+0Fh]

include vars.inc
.186

code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:
                jmp    program_start
                DB      01h
title_msg       DB     0E1h,"IDE BIOS̗eʏgCHSҰύXmANTI-CFؾānV5.30F Af,Ap2,As2",13,10,0
msg_not_for_A2  DB     0E1h,"PC-9821Ap2,As2,Af ȊŐ@ɂ͑Ή܂.",0
machine_typeUN  DB     0E1h,"Af,Ap2,As2łȂ  ",0

;PC-9821Ap2,As2,Afp 

program_start:  
                enter   36,0
                cld
                mov     COLOR_ATTRIB,0E1h
                call    ResoModeCheck   ; nC]^m[}`FbNT-VRAMZOg擾
                call    GetSeg_IDEBIOS  ; ^,RAMIDE BIOSZOg𓾂
                call    GetDisplayLine  ; ITF TEXTʕ\s̐ݒ
                call    DisplayTitle    ; ^Cg\
                call    CheckDIPSW25  ; XCb`̃[hݒ擾
                call    Scan_GRPH_FK    ; 2024-3-25 ǉidlύXj 
                jc      CancelCTRL

                call    ModelCheckAP2   ; @풲
                jc      WrongMachine
                call    PeriEnvCheckA1  ; A1mateƔfROM`FbN
                jmp     @f
                call    PeriEnvCheckB   ; A2,B2@ƔfROM`FbN
        @@:     jc      WrongMachine    ; CY=G[Œ~
                call    Exist_IDE_BIOS  ; IDE BIOS̑݃`FbN
                jc      ExitProgram     ; CY=G[Œ~
                mov     dx,offset msg_CRLF
                call    _puts

                call    CheckMemSwitch  ; XCb`̃[hݒ擾
                jc      ExitProgram     ; CY=G[ŏI

                call    ROMtoMEM        ; IDE BIOS ROMMEMɓ] 8KB 2 time
                call    A2_patch        ; A2@̃pb`
                jc      WrongBIOS

                call    SetChkSum
PatchSucces:
                call    MEMtoIDEBIOS    ; ̍ƌʂRAM BIOSɃRs[
                call    ClearMEMseg     ; ƃNAđދ
ExitProgram:
                call    ShiftKeyCheck   ; VtgL[ŕ\ꎞ~
                call    SetDisplayLine
                leave
                RET    ; near ^[ŏI
;-------------------------------------------
WrongMachine:   mov     dx,offset wrong_msg 
                call    _puts   ; ű@ɂ͑ΉĂ܂v\
                jmp     ExitProgram     ; G[ŏI
CancelCTRL:     mov     dx,offset msg_CRLF
                call    _puts
                jmp     AvoidPatch
WrongBIOS:      call    Poop ; ````
                mov     dx,offset wrong_bios    ; uΉBIOSł͂Ȃv
                call    _puts
AvoidPatch:     mov     dx,offset msg_AvoidPatch; u~܂v 
                call    _puts
                jmp     ExitProgram
To_abort:       mov     dx,offset msg_not_for_A2
                call    _puts
                call    Poop ; ````
                jmp     AvoidPatch

;-----------------------------------------------------------------------
PeriEnvCheckB   PROC   near ; SASI BIOSׂ͒ȂiDISKڑUNITgp֎~j
                in      al,0F0h
                OR      equip,IDE_equip ; IDE BIOS o
                test    flagset, F_HIRESO  ; nC]Ȃ疳
                jnz     @f              ; SOUND BIOS݂͑ȂƂ
                mov     dx,841Eh        ; DIP switch 𒲂ׂɍs@g
                in      al,dx           ; Ap,As,Aeł͕ʂ̌o@I
                test    al,02h          ; bit 1: Undoc2 ƈႤ̂Œ
                jz      EndCheckSoundBIOS
                or      equip,SND_equip ; TEhBIOSL
                mov     dx,offset msg_sound_bios
                call    _puts
EndCheckSoundBIOS:
                clc
                ret
        @@:     stc
                ret
PeriEnvCheckB   ENDP

;--------------------------------------------------------
;         CheckDIPSW25 P,Q
;--------------------------------------------------------
CheckDIPSW25    PROC   near
                in      al,31h
                test    al,00010000b
                jz      @f
                or      flagset,F_MEMSW_INI
                inc     StartLine
        @@:     ret
CheckDIPSW25    ENDP

;--------------------------------------------------------
;       PeriEnvCheckA1  
;--------------------------------------------------------
PeriEnvCheckA1  PROC    near
                in      al,0F0h
                or      equip,IDE_equip
                test    al,40h          ; SCSI(A-mate)݂͑邩?
                jnz     @f
;                or      equip,E10_equip ; SCSI BIOS L
         @@:
                test    flagset,F_HIRESO   ; nC]Ȃ疳
                jnz     CheckHires100A1
;  A-mateL̕sVXeɂ@ 2024/4/8 
                mov     dx,046Ch
                mov     al,02h
                out     dx,al
                mov     dx,0468h
                in      al,dx
                in      al,dx
                in      al,dx
                in      al,dx
                in      al,dx   ; KTAœǂݏo
                test    al,1    ; SOUND BIOSLbit 0, ڑtL bit 2
                jNz     @f      ; SOUND BIOSL
                or      equip,SND_equip ;
                mov     dx,offset msg_soundbios
                call    _puts
;                call    equip80h
EndCheckSoundBIOS_A1:
                clc
                ret
.386
CheckHires100A1:  
                mov     ax,0EA00h
                mov     es,ax
                mov     eax,es:[00h]
                cmp     eax,0CB9090CBh
                jne     EndCheckSoundBIOS_A1
                mov     eax,es:[08h]
                cmp     eax,02AA5590h
                jne     EndCheckSoundBIOS_A1
                mov     eax,es:[30h]
                cmp     eax,504E5024h
                jne     EndCheckSoundBIOS_A1
                mov     eax,es:[60h]
                cmp     eax,534F4942h
                jne     EndCheckSoundBIOS_A1
                or      equip,EA00_equip ;
                mov     dx,offset msg_EA00bios
                call    _puts
                clc
                RET
msg_EA00bios    DB      0E1h,"HIRES100o",0
msg_soundbios   DB      0E1h,"BIOSL",0
PeriEnvCheckA1  ENDP
if 0
equip80h        PROC   near
                dec     ROW
                dec     ROW
                mov     COLUMN,56
                call    _puts
                inc     ROW
                inc     ROW
                ret
equip80h        ENDP
endif
;--------------------------------------------------------


.186
;--------------------------------------------------------
;       machines
;--------------------------------------------------------

include patch_a2.inc

;------------------------------------------------------------
;       ModelCheckAP2
;------------------------------------------------------------
ModelCheckAP2   PROC   near
                mov     dx,offset title_mactype
                call    _puts
                mov     al,MachineID
                or      al,al
                jz      Machine_A1m
                cmp     al,80h  
                je      Machine_A1m
                cmp     al,07h  ; Bp,Bs,Be,PC-9801 BX2,BA2
                je      Machine_B2
                cmp     al,08h  ; Ce2,Cs2
                je      Machine_C2
                cmp     al,05h ; Af
                je      Machine_A2
                cmp     al,81h ; Af(H)
                je      Machine_A2
                cmp     al,06h ; Ap2,As2
                je      Machine_A2
                cmp     al,82h ; Ap2,As2(H)
                je      Machine_A2
                mov     MachineType,0
                mov     dx,offset machine_typeUN
                jmp     MachineWrong
                
Machine_C2:     mov     MachineType,3   ; 3=Cs2,Ce2
                mov     dx,offset machine_typeC2  
                jmp     MachineWrong
Machine_B2:     mov     MachineType,2   ; 2=B2
                mov     dx,offset machine_typeB2  
MachineWrong:   
                call    _puts
                stc
                ret
Machine_A1m:    mov     MachineType,4   ; Ae,As,Ap
                mov     dx,offset machine_typeA1
                jmp     MachineOK
Machine_A2:     mov     MachineType,1   ; Af,Ap2,As2
                mov     dx,offset machine_typeA2
MachineOK:      
                call    _puts
                clc
                ret
ModelCheckAP2   ENDP

;------------------------------
include memcopy.inc
include ideptcom.inc
include setmode6.inc
include numeric.inc     ; l\[`
include e:\asmlib\putstrCS.inc      ; \[`i\[X͕t܂j
;-----------------------------------------
;--------------------------------------
.186

;--------------------------------------
;  W    [2082h]    CylnN(BIOS,logical)
;  B    [208Ah]    SectN(device,physical)
;  B    [208Bh]    HeadN(device,physical)
;  W    [208Ch]    Head:SectN(device,physical)

;  B    [208Eh]    SectN(BIOS,logical)
;  B    [208Fh]    HeadN(BIOS,logical)

;----------------------------------
PatPtn2_Func84  label word      ; offset 033Fh
                push    ax
                mov     si,2080h
                test    byte ptr [bp+00],01h
                jz      @f
                mov     si,2090h
        @@:
                mov     al,byte ptr SectN  ; S
                mov     [bp+06h],al
                mov     al,byte ptr HeadN  ; H
                mov     [bp+07h],al
                mov     dx,word ptr CylnN  ; C
                mov     [bp+04h],dx
                pop     ax
                ret
PatPtn2_Func84_end  label word
if 0
;--------------------------------------------------------
;         CheckDIPSW25 P,Q
;--------------------------------------------------------
CheckDIPSW25    PROC   near
                cmp     MachineType,4
                je      MEMSW_AP
                mov     dx,871Eh
                in      al,dx
                test    al,00100000b
                ret
MEMSW_AP:       mov     dx,0031h
                in      al,dx
                test    al,00010000b
                ret
CheckDIPSW25    ENDP
;----------------------------------
endif
include patch5A2.inc

code    ends
        end     start
