;------------------------------------2025/10/20-------------
GetMemSW6       PROC   near
                mov     es,SegTVRAM     ; !
                mov     al,es:[3FF6h]   ; XCb`U̎w݂
                and     al,00000111b    ; }XN
                or      al,al           ; XCb`ÔƂ
                jnz     @f
                inc     al              ; ÔƂPftHg
        @@:     mov     ModeID,al       ; 
                ret
GetMemSW6       ENDP
;--------------------------------------------------------------+
;       CheckResoMode_for_IDE   ɂP񂾂R[
;------------------------------------2025/10/20----------------+
CheckResoMode_for_IDE   PROC   near
                mov     MachineID,0FFh
                mov     MemWindowAddr, 0Ch  ; m[}[hIDEɂ0Ch
                mov     MemWindowNative, 08h
                mov     MemBankIOAddr,0461h
                mov     SegTVRAM,0A000h
                mov     SegPhysIDEBIOS,0D800h
                mov     SegMMapIDEBIOS, 9800h
                mov     cx,0F8E8h
                xor     bx,bx           ; bx=0
                push    ds
                mov     ds,bx
                mov     al,ds:[0501h]
                pop     ds
                mov     ah,00h
                test    al,08h
                jz      EndModeCheck
; hiresolution mode
                or      flagset,F_HIRESO
                mov     MemWindowAddr, 0Eh  ; High reso[hIDEɂ0Eh
                mov     MemWindowNative, 10h ; 10h=ROM, 08h=DOS
                mov     MemBankIOAddr,091h
                mov     SegTVRAM,0E000h
                mov     SegPhysIDEBIOS,0E600h
                mov     SegMMapIDEBIOS, 8600h
                mov     cx,0FFE8h   ; The segment of Machine ID flag at H.
                mov     ah,80h
EndModeCheck:   
                mov     es,cx
                mov     dx,es:[bx]      ; bx==0
                cmp     dx,2198h
                jne     End9821Check
                mov     al,es:[bx+3Fh]
                or      al,ah
                mov     MachineID,al
End9821Check:
                RET
CheckResoMode_for_IDE   ENDP

;--------------------------------------------------------
;       DisplayTitle  ( Aps/As3/BA3/BX3/486X-matep )
;--------------------------------------------------------
DisplayTitle    PROC    near
                mov     dx,offset title_msg
                call    _puts
                
                mov     dx,871Eh
                in      al,dx
                test    al,00100000b
                jz      @f
                mov     dx,offset msg_dispsw25
                call    _puts
        @@:
                mov     dx,offset msg_mactype
                call    _puts
                mov     dx,ModelNamePtr
                call    _puts
                cmp     MachineType,0   ; Jump if ZERO
                ret
DisplayTitle    ENDP

;--------------------------------------------------------
;       SetDisplayLine  
;--------------------------------------------------------
SetDisplayLine  PROC   near
                push    ds
                mov     ax,ROW
                mov     ds,SegTVRAM
                mov     ds:[3FE0h],al    ; [ITF\sǗAhX]
                pop     ds
                ret
SetDisplayLine  ENDP

;--------------------------------------------------------
;       GetDisplayLine       input   ES = VRAM segment
;--------------------------------------------------------
GetDisplayLine  PROC    near
                xor     ax,ax
                mov     COLUMN,ax
                mov     ROW,MSG_DISP_LINE
                push    ds
                mov     ds,SegTVRAM
                mov     al,ds:[3FE0h]   ; ITF\sǗAhX
                pop     ds
                cmp     al,MSG_DISP_LINE
                ja      LineIndicatorInvalid
                inc     ax
                mov     ROW,ax
LineIndicatorInvalid:
                mov     ax,ROW
                mov     StartLine,al
                ret
GetDisplayLine  ENDP


;--------------------------------------------------------
;       ShiftKeyCheck
;--------------------------------------------------------
ShiftKeyCheck   PROC    near
LoopPressShift: mov     ah,02h
                int 18h
                test    al,00010001b    ; 1=SHIFT, 8=GRPH, 16=CTRL
                jnz     LoopPressShift
                ret
ShiftKeyCheck   ENDP

;-----------------------------------------------------------------------------
;       Sector256Byte  256oCgݒ肩ǂ Ap3,486X(2䑕\@)p
;-----------------------------------------------------------------------------
Sector256Byte   PROC   near
                mov     dx,841Eh        ; \tgEFADIPXCb`
                in      al,dx
                and     al,01000000b    ; bit 6Y
                jz      Exist256BS      ; [Ȃ256Byte/sector
                clc
                ret
Exist256BS:     mov     dx,offset msg_Sector256B
                call    _puts
                stc
                ret
Sector256Byte   ENDP

;--------------------------------------------------------
;       Exist_IDE_BIOS  2nd Gen.
;--------------------------------------------------------
Exist_IDE_BIOS  PROC   near
                push    ds
                mov     ds,SegPhysIDEBIOS
                mov     ax,ds:[0008h]   ; ? C-BUS ROM
                mov     bx,ds:[000Ah]   ; ? C-BUS ROM
                pop     ds
                cmp     ax,05590h         ; C-BUS ROM signature
                jnz     NoExist_IDE_BIOS
                cmp     bx,2AAAh          ; C-BUS ROM type ID
                jnz     NoExist_IDE_BIOS
;                mov     dx,offset IDE_msg ; uIDE BIOS܂v
;                call    _puts
                clc
                ret
NoExist_IDE_BIOS:  
                mov     dx,offset absent_msg
                call    _puts
                stc
                ret
Exist_IDE_BIOS  ENDP

;--------------------------------------------------------------------
;       scan_pattern     ̔r[`    for IDE BIOS
;       <input>
;       DS:SI rp^[,         CX p^[̃oCg
;       ES:DI p^[ꏊ,         DX ͈̔̓oCg
;       <output>        < j AX,BX,CX,DX,DI >
;       CY =NONE ,  NC= ES:BX   carry0̂Ƃ  ES:BXɌoꏊԂ
;--------------------------------------------------------------------
scan_pattern     PROC    near
                cld
                mov     di,0040h
                sub     cx,si
                mov     dx,2000h-40h
                sub     dx,cx

                xor     bx,bx
                add     dx,di
scan_ent:       mov     ax,ds:[si]
                cmp     ax,es:[di]
                jnz     scan_No_match
                mov     bx,di
                push    cx
                push    si
                push    di
         repz   cmpsb
                or      cx,cx
                pop     di
                pop     si
                pop     cx
                jnz     scan_No_match
                clc                     ; scan OK
                ret
scan_No_match:  inc     di
                cmp     di,dx
                jb      scan_ent
                stc                     ; scan NG
                ret
scan_pattern    ENDP

;---------------------------------------------------------
Tone98Set       PROC    near
                mov DX,03FDBh        ; 3FDB
                out DX,AL
                out     5Fh,al
               xchg AL,AH
                out DX,AL
                out     5Fh,al
                ret
Tone98Set       ENDP
;--------------------------------------------------------
;--------------------------------------------------------
BeepSound       PROC   near
                push    cx
                push    dx
                call    Tone98Set
                mov     al,6            ; BEEP ON
                out 37h,al              
                mov     cx,bx
        @@:     out     5Fh,al  ; ҂
                out     5Fh,al
               loop     @b
                mov     al,7            ; BEEP OFF
                out 37h,al              
                mov     ax,04CDh        ; normal freq.
                call    Tone98Set
                pop     dx
                pop     cx
                ret
BeepSound       ENDP
;--------------------------------------------------------
;       Poop
;--------------------------------------------------------
Poop            PROC   near
                push    ax
                push    bx
                mov     ax,5000
                mov     bx,6543h 
                call    BeepSound
                pop     bx
                pop     ax
                ret
Poop            ENDP
;--------------------------------------------------------
;       Peee
;--------------------------------------------------------
Peee            PROC   near
                push    ax
                push    bx
                mov     ax,3750
                mov     bx,0FFF0h 
                call    BeepSound
                pop     bx
                pop     ax
                ret
Peee            ENDP

IF 0
;--------------------------------------------------------
;       ClearMEMseg
;--------------------------------------------------------
ClearMEMseg     PROC    near
                push    es
                mov     cx,2000h/2
                mov     ax,MEMseg
                mov     es,ax
                xor     ax,ax
                mov     di,ax
           rep  stosw
                pop     es
                ret
ClearMEMseg     ENDP
ENDIF

;----------------------------------------------------------------------
;       ResoModeCheck   ŏɂP񂾂Ăяo`FbN output ES
;----------------------------------------------------------------------

;-------------------------------------------------------------------
digit_1         PROC   near     ; input al
                push    bx
                mov     bx,offset num_space
                add     al,'0'  ; AL-->+30h  0-->"0"
                mov     cs:[bx+1],al
                mov     dx,bx
                call    _puts
                pop     bx
                ret
num_space       DB      081h,20h,20h,0
digit_1         ENDP

