;XMATEPCI        equ 1   ;   Xa,XtΏۂɂƂLɂ (r)
ANHIRES         equ 1   ;    PC-9821AnΏۂɂƂLɂ (r)
;----------------------------------------------------------------------------
; PC-9821(i486) IDE BIOS patch Version 5.32 (C) 2006,2018-25 ܂
;----------------------------------------------------------------------------
MEMseg          equ     5800h   ; < 8000h
IDE_equip       equ     10h     ; IDE BIOS bit
;E10_equip      equ     20h     ; E10 BIOS bit(X-mateł͗v)  
SND_equip       equ     80h     ; SND BIOS bit(A-mate,FELLOW)
EA00_equip      equ     80h     ;
; p[^[h̒萔l(l)
MODE_M9         equ  0
MODE_MIXED_SCSI equ  1
MODE_ORTHO_SCSI equ  2
MODE_MEL_SCSI   equ  3
MODE_SSD_SCSI   equ  4
MODE_MIXED_SSD  equ  5
MODE_32255      equ  6

F_INSCSI        equ     10h
F_PCI           equ     04h
F_AN            equ     02h
F_HIRESO        equ     01h

MSG_DISP_LINE   equ     7      ; \JnsłBKXĂB
; Global stack variables -----------------
COLOR_ATTRIB    equ     byte ptr [bp-3] ; \F
ROW             equ     word ptr [bp-4] ; \s
COLUMN          equ     word ptr [bp-6] ; \J
SegTVRAM        equ     word ptr [bp-8] ; T-VRAM̃ZOgA000/E000
NEW_ENTRY       equ     word ptr [bp-10] 
flagset         equ     byte ptr [bp-12]
equip           equ     byte ptr [bp-13] ; 00h ; Flags of SCSI,IDE,SOUND BIOS existence
ModeID          equ     byte ptr [bp-14] ; ݂̃p[^[h
StartLine       equ     byte ptr [bp-15] ; 
MachineID       equ     byte ptr [bp-16] ; Machine ID
MachineType     equ     byte ptr [bp-17] ; [1]=Ap3/As3, [2]=Xe/Xs/Xp,[3]9801BX3 [4]=An, [5]=Cx/Cb, [0]=Others
MemWindowAddr   equ     byte ptr [bp-18] ; 08-BANK window address in EXROM
MemWindowNative equ     byte ptr [bp-20] ; 08-BANK window native address
MemBankIOAddr   equ     word ptr [bp-22] ; 0461h/0091h(nC])
SegPhysIDEBIOS  equ     word ptr [bp-24] ; IDE BIOSZOgiIj
SegMMapIDEBIOS  equ     word ptr [bp-26] ; IDE BIOSZOgiRAMmappingj
SegPhysIDEwork  equ     word ptr [bp-28] ; IDE work areaZOgiIj
ModelNamePtr    equ     word ptr [bp-30] 


code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:
                jmp    program_start
                org 103h
DefaultModeEx   DB      01h

ifdef   XMATEPCI
title_msg       DB      0E1h,"IDE BIOS̗eʏgCHSҰύXmANTI-CFؾāni486 X-Matep  V5.32",13,10,0
endif
ifdef   ANHIRES
title_msg       DB      0E1h,"IDE BIOS̗eʏgCHSҰύXmANTI-CFؾānIDE BIOS3p V5.32",13,10,0
endif


;----------------------------------------------------------------------------
absent_msg      DB      41h,"IDE BIOSoĂ܂ifBXNڑj"
msg_CRLF        DB      20h," ",13,10,0
;IDE_msg        DB     0E1h,"IDE BIOS݂܂. ",13,10,0 ; TCYk̂ߔp~
msg_set         DB     0E1h,"ݒ",0
msg_param_is    DB     0E1h,"[h",0
msg_default     DB     0E1h,"f̫g",0
wrong_bios      DB     0C1h,"ΉȂBIOSł. ",0
wrong_msg       DB     041h,"̋@ɂ͑Ή܂. ",13,10,0
msg_Sector256B  DB      61h,"ZN^256oCg̐ݒł. ",0
msg_AvoidPatch  DB     0E1h,"pb`𒆎~܂.",13,10,0
msg_dispsw25    DB     0C1h,"ĳ DIP  2-5uvɐݒ̂, p[^[h͕ۑ܂.",13,10,0

.186
program_start:
                enter   36,0
                cld
                mov     COLOR_ATTRIB,0E1h      ; RAMIDE BIOSZOg𓾂
                call    CheckResoMode_for_IDE  ; T-VRAMZOg擾
                call    GetMemSW6       ; MEMSW6擾
                mov     equip,IDE_equip ; bit̏l
                call    GetDisplayLine  ; ITF TEXTʕ\s̐ݒ
.386
                call    ModelCheck      ; 9821@풲callԒnoffset擾
                call    DisplayTitle    ; ^Cg\
                jz      AvoidPatch
                mov     dx,offset msg_CRLF
                call    _puts
                call    Scan_GRPH_FK    ; 2025-3-20 dlύX
                jc      AvoidPatch

                call    Exist_IDE_BIOS  ; IDE BIOS̑݃`FbN
                jc      ExitProgram     ; CY=G[Œ~

                call    PeriEnvCheck3   ; 3-gen. 486@ ROM`FbN
;;;             jc      WrongMachine    ; CY=G[Œ~

                call    Sector256Byte   ; BIOSZN^𒲍
                jc      AvoidPatch      ; CY=G[ŏI

                call    DisplayParamMode6    ; p[^[hVer.6̕\
                cmp     ModeID,6
                je      AvoidPatch

                call    ROMtoMEM        ; IDE BIOS ROMMEMɓ] 8KB
                call    Capa_Patch      ; eʐK[`ׂiKvj
                mov     ax,MEMseg
                mov     es,ax
                mov     al,ModeID
                mov     es:[0007h],al   ; mode
                call    An_Ap3_Common_Patch
                jc      WrongBIOS

ifdef ANHIRES
                call    AN_patch        ; PC-9821Añpb`
                jnc     AN_OK  ;      jc WrongBIOS
endif

                call    AP3_BX3_patch   ; Ap3BX3ACxA486X-matẽpb`
                jc      WrongBIOS
AN_OK:
                call    AdvPIO_patch

                call    MEMtoIDEBIOS    ; ̍ƌʂRAM BIOSɃRs[
ExitProgram:  
;                call    ClearMEMseg     ; ƃNAđދ
                call    ShiftKeyCheck   ; VtgL[ŕ\ꎞ~
CancelExec:
                call    SetDisplayLine
                LEAVE   ; 80286ȏ̖
                RET     ; near ^[ŏI
;-------------------------------------------
WrongBIOS:      mov     dx,offset wrong_bios    ; uΉBIOSł͂Ȃv
                call    _puts
AvoidPatch:     mov     dx,offset msg_AvoidPatch; u~܂v 
                call    _puts
                jmp     ExitProgram
WrongMachine:   mov     dx,offset wrong_msg 
                call    _puts           ; ű@ɂ͑ΉĂ܂v\
                jmp     ExitProgram     ; G[ŏI
;========================================


;----------------------------------------------------------------
;       PeriEnvCheck3 ( equiped peripherals ) Ap3,As3,BA3,BX3 only
;----------------------------------------------------------------
PeriEnvCheck3    PROC    near
; port F0h      1= HDD/IF Ȃ ,  0=HDD/IF  _
; bit 6: ^Cv(SCSI)HDDXe[^X            40h 
; bit 5: ^Cv(SASI,IDE)HDDXe[^X        20h
                in      al,0F0h ; IDE BIOS݂ȂƂ̂̓G[ƂȂ

                test    al,40h          ; SCSI(A-mate)݂͑邩?
                jnz     noequip_E10_FA02        ; 2019-1-21
                cmp     MachineType,2   ; Xe,Xs,XpI/O F0 flag bit6̈Ӗ
                je      noequip_E10_FA02   ; Ⴄ悤Ȃ̂Œ!!
                OR      flagset,F_INSCSI
noequip_E10_FA02:
                test    flagset,F_HIRESO  ; nC]Ȃ疳
                jnz     equip_hireso ; SOUND BIOS݂͑ȂƂ
                mov     dx,841Eh        ; DIP switch 𒲂ׂɍs@g
                in      al,dx
                test    al,02h          ; bit 1: Undoc2 ƈႤ̂Œ
                jz      @f ; Ap,As,Aeł͕ʂ̌o@I
                or      equip,SND_equip 
        @@:   ; SASI BIOSׂ͒ȂƂɂ
                clc
                ret

equip_hireso:  ; 2025-10-20 mod.        for 100 board
                mov     ax,0EA00h
                mov     es,ax
                mov     eax,es:[0]
                cmp     eax,0CB9090CBh  ; boot ROM
                jne     @f
                mov     eax,es:[8]
                cmp     eax,02AA5590h   ; SCSI I/F
                jne     @f
                mov     eax,es:[30h]
                cmp     eax,504E5024h   ; "$PNP"
                jne     @f
                mov     eax,es:[60h]
                cmp     eax,534F4942h   ; "BIOS"
                jne     @f
                or      equip,EA00_equip
        @@:     clc
                RET
PeriEnvCheck3   ENDP


;--------------------------------------------------------
;       machines
;--------------------------------------------------------
include capa_pat.inc
include AnAp3Pat.inc
include ap3_pat.inc
ifdef ANHIRES
include an_pat.inc
endif
;--------------------------------------------------------
;       MEMtoIDEBIOS    5C00:0-->D800:0
;--------------------------------------------------------
MEMtoIDEBIOS    PROC   near
                test    flagset,F_PCI
                jz      @f      ; PCI machine
                mov     ax,SegPhysIDEBIOS   ; SegMMapIDEBIOS = SegPhysIDEBIOS
                mov     SegMMapIDEBIOS,ax
        @@:
                mov      al,equip ; Internal IDE,SCSI,SND BIOS enable
                pushf
                cli     ; BIOSRAMւ̓]͊荞݋֎~Ƃ
                test    flagset,F_PCI
                jnz     @f
                call    ROMRAM486_IDE   ; ݒALbVtbV
                jmp     ROMRAM_END
        @@:     
ifdef XMATEPCI
                call    ROMRAM8086_IDE
endif
ROMRAM_END:
                call    MEMtoROM        ; MEM̃f[^RAMBIOSɃRs[
                test    flagset,F_PCI
                jnz     @f
                call    RAMROM486_IDE   ; sݒALbVtbV
                jmp     RAMROM_END
        @@:     
ifdef XMATEPCI
                call    RAMROM8086_IDE
endif
RAMROM_END:
                popf
                ret     ; G[Ԓl͂Ȃ̂Ƃ
MEMtoIDEBIOS    ENDP

ifdef XMATEPCI
PCIset5C        PROC   near
                mov     eax,8000005Ch   ;reg 5Dh
                pop     ax
                mov     dx,0CF8h
                out     dx,eax
                mov     dl,0FCh
                in      eax,dx
                ret
PCIset5C        ENDP
ROMRAM8086_IDE  PROC   near
                call    PCIset5C
                or      ah,00000011b    ; Write enabled 
                out     dx,eax
                ret
ROMRAM8086_IDE  ENDP
RAMROM8086_IDE  PROC   near
                call    PCIset5C
                or      ah,11111101b    ; Write enabled 
                out     dx,eax
                ret
RAMROM8086_IDE  ENDP
endif
;--------------------------------------------------------
;       MEMtoROM        5000:0-->ES:0   ES=RAMwindowIDE
;--------------------------------------------------------
MEMtoROM        PROC    near
                mov     es,SegMMapIDEBIOS
                cld
                mov     cx,2000h/2      ; 8KB
                push    cx
                xor     ax,ax
                mov     si,ax
                mov     di,ax
                push    si
                mov     ax,MEMseg
                push    ds
                mov     ds,ax   ; ds=MEMseg, es=IDE BIOSRAMwindow
           rep  movsw
                pop     ds
                pop     si
                pop     cx
                ret
MEMtoROM        ENDP

;--------------------------------------------------------
;       ROMtoMEM        ds=D800:0-->5000:0
;--------------------------------------------------------
ROMtoMEM        PROC    near
                mov     dx,SegPhysIDEBIOS   ; DXɐ^IDE BIOS̃ZOg
                cld
                mov     cx,2000h/2      ; 8KB
                sub     si,si
                sub     di,di
                mov     ax,MEMseg
                push    ds
                mov     ds,dx   ; DS=DX=^IDE BIOSZOg
                mov     es,ax   ; ES=AX=MEMseg
          rep   movsw
                pop     ds
                ret
ROMtoMEM        ENDP

;--------------------------------------------------------
;       ROMRAM486_IDE  (ex)     A-mate
;--------------------------------------------------------
ROMRAM486_IDE   PROC    near
                mov     dx,043Fh ;
                mov     al,0A0h   ; clear cache
                out     dx,al
                mov     dx,MemBankIOAddr         ; 8-9 bank selected to
                mov     al,MemWindowAddr        ; address C000 or E000h.
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,02h   ; RAM window access enable =bit2=0
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                ret
ROMRAM486_IDE   ENDP
;--------------------------------------------------------
RAMROM486_IDE   PROC    near
                mov     dx,MemBankIOAddr         ; 8-9 bank selected to
                mov     al,MemWindowNative      ; address 8000h or 10000h
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,06h   ; RAM window access disable =bit2=1
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                mov     dx,043Fh ;
                mov     al,0A0h  ; Invalidate CPU cache
                out     dx,al
                ret
RAMROM486_IDE   ENDP

;------------------------------------------------------------
;       ModelCheck      BA3,BX3, Xe,Xs,Xp,Xn, Ap3,As3, An
;------------------------------------------------------------
ModelCheck      PROC   near
                mov     al,MachineID
                cmp     al,12h  ; Xe/Xs/Xp?
                je      Machine_XMATE
ifdef XMATEPCI
                cmp     al,13h  ; Xa/Xt
                je      Machine_XMATE_PCI
endif
                cmp     al,84h  ; Ap3/As3 H
                je      Machine_A3
                cmp     al,18h  ; Ap3/As3 N
                je      Machine_A3
                cmp     al,83h  ; An H
                je      Machine_An
                cmp     al,0Dh  ; An N
                je      Machine_An
                cmp     al,16h  ; BX3
                je      Machine_B3
                cmp     al,15h  ; Cx,Cb
                je      Machine_C1
                mov     MachineType,0
                mov     ax,1C10h
                jmp     ModelCheckFail       ; added 2025/7/17
ModelCheckEnd: 
                mov     NEW_ENTRY,ax
                mov     bx,offset TABLE_OFFSET_IN_BIOS
                add     [bx],ax
                mov     bx,offset CALL_OFFSET2
                add     [bx],ax
                mov     bx,offset CALL_OFFSET3
                add     [bx],ax
                mov     bx,offset CALL_OFFSET4
                add     [bx],ax
                
                cmp     MachineType,4   ; An
                je      @f
                mov     bx,offset CALL_OFFSET1  ; B*3,X*
                add     [bx],ax
                mov     bx,offset CALL_OFFSET5  ; B*3,X*
                add     [bx],ax
                jmp     ModelCheckOK
        @@:
ifdef ANHIRES
                mov     bx,offset CALL_OFFSET6  ; An 
                add     [bx],ax
                mov     bx,offset CALL_OFFSET7  ; An 
                add     [bx],ax
endif
ModelCheckOK:
                mov     ModelNamePtr,dx
                clc
                ret
ModelCheckFail:
                mov     ModelNamePtr,offset machine_typeUN
                stc
                ret

Machine_C1:     mov     MachineType,5
                jmp     Machine_A3C3
Machine_A3:     mov     MachineType,1
Machine_A3C3:   mov     ax,1C10h
                mov     dx,offset machine_typeAC3
                jmp     ModelCheckEnd
Machine_B3:     mov     MachineType,3
                mov     ax,1C10h
                mov     dx,offset machine_typeB3
                jmp     ModelCheckEnd
ifdef XMATEPCI
Machine_XMATE_PCI:
                mov     eax,80000000h
                mov     dx,0CF8h
                out     dx,eax
                mov     dl,0FCh
                in      eax,dx
                cmp     ax,8086h
                jNe     ModelCheckFail
                mov     MachineType,9
                or      flagset,F_PCI
                mov     dx,offset machine_typeXa
                jmp     ModelCheckEnd
endif

Machine_XMATE:  mov     MachineType,2
                call    CheckXM         ; X-matẽj[^Cv΍ 2024/3/24
                mov     dx,offset machine_typeX
                jmp     ModelCheckEnd

Machine_An:     mov     MachineType,4
                mov     dx,45Fh
                mov     al,4Fh
                out     dx,al
                mov     ax,1C10h
                mov     dx,offset machine_typeAn
                or      flagset,F_AN
                jmp     ModelCheckEnd
ModelCheck      ENDP

ifdef   XMATEPCI
machine_typeXa  DB      0E1h,"PC-9821 Xa,Xt",0
endif
machine_typeX   DB      0E1h,"PC-9821 Xn,Xp,Xs,Xe",0
machine_typeAn  DB      0E1h,"PC-9821 An",0
machine_typeUN  DB      0E1h,"s ",0
machine_typeAC3 DB      0E1h,"PC-9821 Ap3/As3, Cb/Cx",0
machine_typeB3  DB      0E1h,"PC-9801 BX3,BX3",0
msg_mactype     DB      0E1h,"@ ",0

CheckXM         PROC   near     ; X-mateIDE BIOSǉŊȒPɒ 2024/3/24
                push    es
                mov     es,SegPhysIDEBIOS
                mov     eax,es:[1FDCh]
                cmp     eax,0E292C582h
                mov     ax,1DA0h
                jne     @f
                mov     ax,1C10h
        @@:     pop     es
                ret
CheckXM         ENDP

;------------------------------
include advpio.inc
include e:\asmlib\putstrCS.inc      ; \[`
include ideptcom.inc
include setmode6.s
;------------------------------
align 4
                DD      0EEEEEEEEh      ; I[}[J[
ProgramSize     equ     ( offset CodeEnd - offset Excode )
;==================================
include xc4m486.s
DB      0,0,0,"ROM̕E̔ւ܂. (C)2025",0,0
DB      32 dup(0)
;==================================
code    ends
        end     start
