ExistIDEBIOS    PROC   near
                mov     es,SegPhysIDEBIOS   ; DXɐ^IDE BIOS̃ZOg
                mov     ax,es:[0009h]   ; ? C-BUS ROM
                mov     bx,es:[000Bh]   ; ? C-BUS ROM
                cmp     ax,0AA55h       ; C-BUS ROM signature
                jnz     NoExist_IDE_BIOS
                cmp     bl,2Ah          ; C-BUS ROM type ID
                jnz     NoExist_IDE_BIOS
                mov     dx,offset IDE_msg
                call    _puts
                clc
                ret
NoExist_IDE_BIOS:
                mov     dx,offset BIOSabsent_msg
                call    _puts
                stc
                ret
ExistIDEBIOS    ENDP

;--------------------------------------------------------
;       CheckDIPSW25  1  in al,31h
;--------------------------------------------------------
CheckDIPSW25    PROC   near
                in      al,31h
                test    al,00010000b
                jz      @f
                or      flagset,F_MEMSW_INI
                inc     StartLine
        @@:     ret
CheckDIPSW25    ENDP

;--------------------------------------------------------
;       ShiftKeyCheck
;--------------------------------------------------------
ShiftKeyCheck   PROC    near
LoopPressShift: mov     ah,02h
                int 18h
                test    al,00010001b    ; 1=SHIFT, 8=GRPH, 16=CTRL
                jnz     LoopPressShift
                ret
ShiftKeyCheck   ENDP


;---------------------------------------------------------------------
;   Sector256Byte  256oCgݒ肩ǂ 486(2䑕\@)p
;---------------------------------------------------------------------
Sector256Byte   PROC   near
if 0
                mov     dx,841Eh        ; \tgEFADIPXCb`
                in      al,dx
                and     al,01000000b    ; bit 6Y
                jz      Exist256BS      ; [Ȃ256Byte/sector
endif
                mov     al,WORK0457
                test    al,10000000b
                jz      Exist256BS
                clc
                ret
Exist256BS:     mov     dx,offset msg_Sector256B
                call    _puts
                stc
                ret
Sector256Byte   ENDP


;---------------------------------------------------------
Tone98Set       PROC    near
                push    dx
                mov     DX,BeepIOA
                out     DX,AL
                out     5Fh,al
               xchg     AL,AH
                out     DX,AL
                out     5Fh,al
                pop     dx
                ret
Tone98Set       ENDP
;--------------------------------------------------------
;--------------------------------------------------------
BeepSound       PROC   near
                call    Tone98Set
                mov     al,6            ; BEEP ON
                out 37h,al              
        @@:     out     5Fh,al  ; ҂
                out     5Fh,al
               loop     @b
                inc     al      ; mov al,7= BEEP OFF
                out 37h,al              
                mov     ax,04CDh        ; normal freq.
                call    Tone98Set
                ret
BeepSound       ENDP
;--------------------------------------------------------
;       Poop
;--------------------------------------------------------
Poop            PROC   near
                push    ax
                push    cx
                mov     ax,dx
                mov     cx,6543h 
                cmp     ax,3750
                jne     @f
                mov     cx,0FFF0h
        @@:
                call    BeepSound
                pop     cx
                pop     ax
                ret
Poop            ENDP

;--------------------------------------------------------
;       GetDisplayLine
;--------------------------------------------------------
MSG_DISP_LINE   equ     14
GetDisplayLine  PROC    near
                mov     dl,MSG_DISP_LINE   
                xor     ax,ax           ; AH=0
                mov     StartLine,al
                mov     COLUMN,ax
                push    ds
                mov     ds,SegTVRAM
                mov     al,ds:[3FE0h]   ; ITF\sǗAhX
                pop     ds
                cmp     al,dl
                jb      LineIndicatorOK
                mov     al,dl
LineIndicatorOK:
                inc     ax
                mov     StartLine,al
                mov     ROW,ax
                ret
GetDisplayLine  ENDP

;--------------------------------------------------------
;       SetDisplayLine
;--------------------------------------------------------
SetDisplayLine  PROC   near
                push    ds
                mov     ax,ROW
                inc     al
                mov     ds,SegTVRAM
                mov     ds:[3FE0h],al    ; [ITF\sǗAhX]
                pop     ds
                ret
SetDisplayLine  ENDP

;--------------------------------------------------------------------
;       scan_pattern     ̔r[`    for IDE BIOS
;       <input>
;       DS:SI rp^[,         CX p^[̃oCg
;       ES:DI p^[ꏊ,         DX ͈̔̓oCg
;       <output>        < j AX,BX,CX,DX,DI >
;       CY =NONE ,  NC= ES:BX   carry0̂Ƃ  ES:BXɌoꏊԂ
;--------------------------------------------------------------------
scan_pattern    PROC    near
                cld
                mov     di,0040h
                sub     cx,si
                mov     dx,2000h-40h
                sub     dx,cx

                xor     bx,bx
                add     dx,di
scan_ent:       mov     ax,ds:[si]
                cmp     ax,es:[di]
                jnz     scan_No_match
                mov     bx,di
                push    cx
                push    si
                push    di
         repz   cmpsb
                or      cx,cx
                pop     di
                pop     si
                pop     cx
                jnz     scan_No_match
                clc                     ; scan OK
                ret
scan_No_match:  inc     di
                cmp     di,dx
                jb      scan_ent
                stc                     ; scan NG
                ret
scan_pattern    ENDP

;--------------------------------------------------------
;       ClearMEMseg
;--------------------------------------------------------
ClearMEMseg     PROC    near
                push    es
                mov     cx,2000h/2
                mov     ax,MEMseg
                mov     es,ax
                xor     ax,ax
                mov     di,ax
           rep  stosw
                pop     es
                ret
ClearMEMseg     ENDP

