FIXBBIOS        equ 1
;----------------------------------------------------------------------------
; PC-9821(Ap,As,Ae) IDE BIOS patch Version 5.31   (C) 2018-21,25 ܂
;----------------------------------------------------------------------------
NEW_ENTRY       equ     1080h
MEMseg          equ     5600h   ; < 8000h
IDE_equip       equ     10h     ; IDE BIOS bit
E10_equip       equ     20h     ; E10 BIOS bit(X-mateł͗v)
SASI_equip      equ     40h
SND_equip       equ     80h     ; SND BIOS bit
EA00_equip      equ     80h     ; EA00 BIOS bit(High resolution mode only)

F_HIRESO        equ     1
F_PCI           equ     2
F_MEMSW_INI     equ     4

; D800:2100 block is not used on this model.
WORK_H_S        equ     2060h   ; WORD  higher byte=HEAD,Lower=SECT
WORK_HS_MUL     equ     2064h   ; WORD
WORK_CYL        equ     2042h ; as same as [2042h]
LogiSectN       equ     2046h   ; BYTE/WORD
LogiHeadN       equ     2047h   ; BYTE
PhysSectN       equ     2066h   ; BYTE/WORD
PhysHeadN       equ     2067h   ; BYTE
LBA_by_CHS      equ     2068h   ; DWORD(WORD)
LBA_by_CHS_H    equ     206Ah   ;      (WORD)
LIM_65535HS     equ     206Ch   ; DWORD(WORD)
LIM_65535HS_H   equ     206Eh   ;      (WORD)

; Global stack variables -----------------
COLOR_ATTRIB    equ     byte ptr [bp-03h] ; \F
SegTVRAM        equ     word ptr [bp-04h] ; T-VRAM̃ZOgA000/E000
ROW             equ     word ptr [bp-06h] ; \s
COLUMN          equ     word ptr [bp-08h] ; \J
StartLine       equ     byte ptr [bp-0Ah] ; \line
WORK0457        equ     byte ptr [bp-0Bh] ; IDE system work area
flagset         equ     byte ptr [bp-0Ch]
MachineType     equ     byte ptr [bp-0Dh] ; [1]=Ap/Ae, [2]=BX/BA  [3]=Ce
equip           equ     byte ptr [bp-0Eh] ; 00h ; Flags of SCSI,IDE,SOUND BIOS existence
ModeID          equ     byte ptr [bp-0Fh] ; ݂̃p[^[h
MachineID       equ     byte ptr [bp-10h] ; Machine ID
MemWindowNative equ     byte ptr [bp-12h] ; 08-BANK window native address
MemWindowAddr   equ     byte ptr [bp-13h] ; 08-BANK window address in EXROM

mem_bank_IOaddr equ     word ptr [bp-16h] ; 0461h/0091h(nC])
SegPhysIDEBIOS  equ     word ptr [bp-18h] ; IDE BIOSZOgiIj
SegMMapIDEBIOS  equ     word ptr [bp-1Ah] ; IDE BIOSZOgiRAMmappingj
LHsum           equ     word ptr [bp-1Ch] ; system work area
BeepIOA         equ     word ptr [bp-1Eh] ;

code            segment public use16
                assume cs:code,ds:code,es:code,ss:code
                org 100h  ; for MS-DOS .COM file
start:
                jmp    program_start
                org 103h
DefaultModeEx   DB      01h
title_msg       DB      0E1h,"IDE BIOS̗eʏgCHSύXmANTI-CFؾānAe,As,Ap,BX,BAp  V5.30F",13,10,0
msg_mactype     DB     0E1h,"@ ",0
machine_typeAC1 DB     0E1h,"PC-9821 Ap,As,Ae, Ce",0
machine_typeB1  DB     0E1h,"PC-9801 BA,BX",0
;machine_typeC1  DB     0E1h,"PC-9821 Ce",0
machine_typeUN  DB     0E1h,"s",0
IDE_msg         DB     0E1h,"  IDE BIOS݂܂.",0
BIOSabsent_msg  DB     041h,"  IDE BIOS݂܂ifBXN̐ڑj",13,10,0
wrong_bios      DB     0C1h,"ΉȂBIOSł. ",0
wrong_msg       DB     041h,"  ̋@ɂ͑Ή܂.",13,10,0
msg_Sector256B  DB      61h,"ZN^256bytesɐݒ肳Ă܂. ",0
msg_AvoidPatch  DB     0E1h,"pb`𒆎~܂.",13,10,0
FixedSYSBIOS    DB     0E1h," SYSTEM BIOSC.",13,10,0
msg_CRLF        DB     0E1h," ",13,10,0
;---------------------------------------------------
.186
program_start:
; mov dx,1E8Eh
; mov al,81h
; out dx,al
                enter   36,0
                cld
                call    ResoModeCheck   ; nC]^m[}`FbNT-VRAMZOg擾
                call    GetDisplayLine  ; ITF TEXTʕ\s̐ݒ
                mov     dx,offset title_msg
                call    _puts           ; ^Cg\
                call    CheckDIPSW25
                call    Scan_GRPH_FK6   ; 2025/10/27dlύX
                jc      ToAvoid
                
                call    ModelCheckAB1   ; @풲
                jc      WrongMachine    ; CYĂ΋@ႢŃG[

                call    PeriEnvCheckA1  ; 486@ƔfROM`FbN
                call    ExistIDEBIOS    ; IDE BIOS̑݃`FbN
                jc      AvoidPatch      ; CY=G[ŏI

                mov     dx,offset msg_CRLF  ; Line2
                call    _puts

                call    DisplayMode6    ; p[^[h̕\
                jc      AvoidPatch      ; CTRL key=CY=G[ŏI

                call    Sector256Byte   ; BIOSZN^𒲍
                jc      AvoidPatch      ; CY=G[ŏI

                call    ROMtoMEM        ; IDE BIOS ROMMEMɓ] 8KB
                call    Patch_A_B       ; Ap/As/Ae  BX/BÃpb`
                jc      WrongBIOS
                call    MEMtoIDEBIOS    ; ̍ƌʂRAM BIOSɃRs[
                call    ClearMEMseg     ; ƃNAđދ
ExitProgram:
                call    ShiftKeyCheck   ; VtgL[ŕ\ꎞ~
                call    SetDisplayLine
                leave
                RET    ; near ^[ŏI
;-------------------------------------------
WrongMachine:   mov     dx,offset wrong_msg 
                call    _puts           ; ű@ɂ͑ΉĂ܂v\
                jmp     ExitProgram     ; G[ŏI
WrongBIOS:      mov     dx,offset wrong_bios    ; uΉBIOSł͂Ȃv
ToAvoid:        call    _puts
AvoidPatch:     mov     dx,offset msg_AvoidPatch; u~܂v 
                call    _puts
                jmp     ExitProgram

;-----------------------------------------------------------------
;       ResoModeCheck   ŏɂP񂾂Ăяo`FbN V5.31
;-----------------------------------------------------------------
ResoModeCheck   PROC    near
                xor     ax,ax
                mov     flagset,al
                mov     equip,al        ; bit̏l
                mov     MachineType,al  ; =0
                mov     es,ax

                mov     mem_bank_IOaddr,0461h
                mov     MemWindowAddr,0Ch
                mov     MemWindowNative,08h
                mov     SegTVRAM,0A000h ; Text VRAMZOg
                mov     SegPhysIDEBIOS,0D800h   ; DXɐ^IDE BIOS̃ZOg
                mov     SegMMapIDEBIOS, 9800h   ; RAMmapping
                mov     BeepIOA,3FDBh   
                mov     bx,0F8E8h       ; Machine ID i[ZOg(BIOS)
;;;;            mov     ah,00h          ; AH bit 7MAchine ID̈ꕔɎg
                mov     al,es:[0457h]   ; 
                mov     WORK0457,al
                mov     al,es:[0501h]           ; hi-reso check
                test    al,8
                jz      EndResolutionSetting
; High Resolution Mode
                or      flagset,F_HIRESO ; high/low mode flag
                mov     mem_bank_IOaddr,0091h ; Hireso mem-window port
                mov     MemWindowNative,10h;  Hireso mem-window native addr
                mov     MemWindowAddr,0Eh  ; E600-->8600
                mov     SegTVRAM,0E000h ; The segment of Text VRAM at H mode
                mov     SegPhysIDEBIOS,0E600h   ; DXɐ^IDE BIOS̃ZOg
                mov     SegMMapIDEBIOS, 8600h   ; RAMmapping
                mov     BeepIOA,0073h
                mov     bx,0FFE8h       ; The segment of Machine ID flag at H.
                mov     ah,80h          ; bit7=1 , Machine IDmnC]rbg
EndResolutionSetting:
                push    ds
                mov     ds,bx
                xor     bx,bx
                mov     dx,ds:[bx]
                mov     al,ds:[bx+3Fh]
;               mov     bl,ds:[bx+04h]
                pop     ds
                cmp     dx,2198h
                je      @f
                mov     al,0FFh
ResoModeCheck_err:
                stc
                ret
        @@:
                or      al,ah           ; nC]bitƍ
                mov     MachineID,al
;               test    bl,00010000b
;               jz      @f
;               or      flagset,F_PCI
;               jmp     ResoModeCheck_err
;       @@:
                clc
                ret
ResoModeCheck   ENDP


;----------------------------------------------------------------
;  PeriEnvCheckA1 ( equiped peripherals ) Ap,As,Ae SOUND BIOS only
;----------------------------------------------------------------
PeriEnvCheckA1  PROC    near
                or      equip,IDE_equip ; IDE ROM ͖ɑ݂Ƃ
;  A-mateL̕sVXeɂ@ 2024/4/8 
                test    MachineType,1   ; 1=A-mate,3=Ce
                jNE     EndCheckSoundBIOS 
Amate1SoftwareSwitch02:
                test    flagset,F_HIRESO
                jnz     CheckHires100
                
                mov     dx,046Ch
                mov     al,02h
                out     dx,al
                mov     dx,0468h
                in      al,dx
                in      al,dx
                in      al,dx
                in      al,dx
                in      al,dx   ; KTAœǂݏo
                test    al,1    ; SOUND BIOSLbit 0, ڑtL bit 2
                jNz     EndCheckSoundBIOS ; SOUND BIOSL
                or      equip,SND_equip ;
                mov     dx,offset msg_soundbios
                call    _puts
EndCheckSoundBIOS:    
                ; SASI BIOSׂ͒ȂifBXNڑjbggp֎~j
                clc
                ret
.386
CheckHires100:  mov     ax,0EA00h
                mov     es,ax
                mov     eax,es:[00h]
                cmp     eax,0CB9090CBh
                jne     EndCheckSoundBIOS
                mov     eax,es:[08h]
                cmp     eax,02AA5590h
                jne     EndCheckSoundBIOS
;                mov     eax,es:[30h]
;                cmp     eax,504E5024h
;                jne     EndCheckSoundBIOS
                mov     eax,es:[60h]
                cmp     eax,534F4942h
                jne     EndCheckSoundBIOS
                or      equip,EA00_equip ;
                mov     dx,offset msg_EA00bios
                call    _puts
                clc
                RET
PeriEnvCheckA1  ENDP
msg_EA00bios    DB      0E1h,"HIRES100o",0
msg_soundbios   DB      0E1h,"sound BIOSL",0

;--------------------------------------------------------
;       machines
;--------------------------------------------------------
include fixbios.s
include patch0.s
include ap_ba.s

;--------------------------------------------------------
;       MEMtoIDEBIOS    5C00:0-->D800:0
;--------------------------------------------------------
MEMtoIDEBIOS    PROC   near
                pushf
                cli     ; BIOSRAMւ̓]͊荞݋֎~Ƃ
                call    ROMRAM486_IDE   ; ݒALbVtbV
                call    MEMtoROM        ; MEM̃f[^RAMBIOSɃRs[
                cmp     MachineType,2
                jne     @f
ifdef FIXBBIOS
                call    FixSYSBIOS      ; SYSTEM BIOSłɉς
endif
        @@:     call    RAMROM486_IDE   ; sݒALbVtbV
                popf
                ret     ; G[Ԓl͂Ȃ̂Ƃ
MEMtoIDEBIOS    ENDP

;--------------------------------------------------------
;       MEMtoROM        5000:0-->ES:0   ES=RAMwindowIDE
;--------------------------------------------------------
MEMtoROM        PROC    near
                mov     es,SegMMapIDEBIOS
                cld
                mov     cx,2000h/2      ; 8KB
                push    cx
                xor     ax,ax
                mov     si,ax
                mov     di,ax
                push    si
                mov     ax,MEMseg
                push    ds
                mov     ds,ax   ; ds=MEMseg, es=IDE BIOSRAMwindow
           rep  movsw
                pop     ds
                pop     si
                pop     cx
                ret
MEMtoROM        ENDP

;--------------------------------------------------------
;       ROMtoMEM        ds=D800:0-->5000:0
;--------------------------------------------------------
ROMtoMEM        PROC    near
                mov     dx,SegPhysIDEBIOS   ; DXɐ^IDE BIOS̃ZOg
                cld
                mov     cx,2000h/2      ; 8KB
                sub     si,si
                sub     di,di
                mov     bx,MEMseg
                push    ds
                mov     ds,dx   ; DS=DX=^IDE BIOSZOg
                mov     es,bx   ; ES=BX=MEMseg
          rep   movsw
                mov     al,ModeID
                mov     es:[0007h],al
                pop     ds
                ret
ROMtoMEM        ENDP

;--------------------------------------------------------
;       ROMRAM486_IDE  (ex)     A-mate
;--------------------------------------------------------
ROMRAM486_IDE   PROC    near
                mov     dx,043Fh ;
                mov     al,0A0h   ; clear cache
                out     dx,al
                mov     dx,mem_bank_IOaddr      ; 8-9 bank selected to
                mov     al,MemWindowAddr        ; address C000 or E000h.
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,02h   ; RAM window access enable =bit2=0
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                ret
ROMRAM486_IDE   ENDP
;--------------------------------------------------------
RAMROM486_IDE   PROC    near
                mov     dx,mem_bank_IOaddr      ; 8-9 bank selected to
                mov     al,MemWindowNative      ; address 8000h or 10000h
                out     dx,al
                mov     dx,053Dh ; 053D_mem_enabler_switch
                mov     al,06h   ; RAM window access disable =bit2=1
                or      al,equip ; Internal IDE,SCSI,SND BIOS enable
                out     dx,al
                mov     dx,043Fh ;
                mov     al,0A0h  ; Invalidate CPU cache
                out     dx,al
                ret
RAMROM486_IDE   ENDP

;------------------------------------------------------------
;       ModelCheckAB      Ap,As,Ae  BA,BX, Ce
;------------------------------------------------------------
ModelCheckAB1   PROC   near
                mov     dx,offset msg_mactype
                call    _puts
                mov     dx,offset machine_typeUN
;               test    flagset,F_PCI
;               jnz     ModelCheckfail

                mov     al,MachineID
                cmp     al,0FFh
                je      Machine_B1
                cmp     al,00h ; A-mate 1
                je      Machine_A1
                cmp     al,80h ; A-mate 1 (H)
                je      Machine_A1
                cmp     al,01h  ; Alterd BX,BA
                je      Machine_B1
                cmp     al,02h  ; Ce
                je      Machine_C1
;               cmp     al,05h  ; Af
;               je      Machine_A2
;               cmp     al,81h  ; Af
;               je      Machine_A2
;               cmp     al,06h  ; Ap2,As2
;               je      Machine_A2
;               cmp     al,82h  ; Ap2,As2
;               je      Machine_A2
;                cmp     al,22h  ; Xe10
;                je      ModelCheckSuccess
                mov     MachineType,0
ModelCheckfail: call    _puts
                stc
                ret
;Machine_A2:     mov     dx,offset machine_typeUN
;                jmp     ModelCheckfail
Machine_C1:     mov     MachineType,3   ; 3=Ce
                mov     dx,offset machine_typeAC1
                jmp     ModelCheckSuccess
Machine_B1:     mov     MachineType,2   ; 2=BA,BX
                mov     dx,offset machine_typeB1
                jmp     ModelCheckSuccess
Machine_A1:     mov     MachineType,1   ; Ap,As,Ae
                mov     dx,offset machine_typeAC1
ModelCheckSuccess:
                call    _puts
                clc
                ret
ModelCheckAB1   ENDP

;------------------------------
include e:\asmlib\putstrCS.inc      ; \[`
include setmode6.s
include ideptcom.s
;------------------------------
ProgramSize     equ     ( offset CodeEnd - offset Excode )
include xc4m1AB.s

;-----------------------------------------
ExCodeEnd       label byte      ; DO NOT MOVE or REMOVE
        DB      0,"ROM̕E̔ւ.",0,"(C)2025 ",0
;        DB      0,"s",0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0,0
code    ends
        end     start
