.8086
;---------------------------------------------------------------------------
;    CBUSLDR.S  C-BUS boot ROM loader (C)2025 ܂(DOSsoft) Version 4.90
;---------------------------------------------------------------------------
DIV0_ENABLE     equ     1
CBUS_BD_ID      equ     1Dh

code            segment
                assume cs:code,ds:code,es:code,ss:code
                org    0
start:          db      0CBh, 90h, 90h
                db      0CBh, 90h, 90h
                db      0CBh, 90h, 90h  ;                       ** bx bx+1
                db       55h,0AAh, CBUS_BD_ID ; C BUS ROM ID =  1D,DD,9D
                org  0Ch
                JMP     ROM_entry1
                nop
                org  0Fh
                db      0CBh, 90h, 90h
                org  12h
                db      0CBh, 90h, 90h
                org  15h
                db      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h
                db      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h
                db      0CBh, 90h, 90h, 0CBh, 90h, 90h, 0CBh, 90h, 90h
.386

ROM_entry1:     mov     byte ptr ds:[bx],(CBUS_BD_ID or 0C0h) ; ROM pruducts and type
                pushf
                pushad
                push    ds
                push    es
ifdef   DIV0_ENABLE
                mov     di,ds
                mov     word ptr ds:[di],offset Div0Recover
                mov     word ptr ds:[di+2],cs
endif
                mov     es,cs:seg_position
                mov     si,offset COM_PROGRAM_START
                mov     di,00F8h        ; DS:SI --> 7000(ES):00F0h
                mov     ax,cs
                stosw   ;       [F8h]=cs,[FAh]=ds
                mov     ax,ds
                stosw
                mov     ax,01E8h   ;  CALL 100, RETF ߃R[h E8 0100 CB
                stosw
                mov     ax,0CB00h  ;  CALL 100, RETF ߃R[h
                stosw

                push    cs
                pop     ds              ; ds=cs, es=7000h
                mov     cx,1000h        ; 8KB ROM = 2000h, 4KB=1000h
                sub     cx,si
        rep     movsb                   ; cs --> es
;;;             mov     es:[00F4h],ds   ; save the original values.
;;;             mov     es:[00F6h],es   ;   of the segment register.
  
;;;;--------- stack switcher -----
                mov     es:[00F0h],ss   ; stack pointer
                mov     es:[00F2h],sp
                cli
                mov     ax,es           ; es=7000h
                mov     ds,ax           ; ds=7000h (new segment)
                mov     ss,ax
                mov     sp,0FF00h       ; save stack pointer
                sti
                ;   call far [7000:00FC]
                DB      9Ah
ofs_position    DW      00FCh
seg_position    DW      7000h           ; 7000h -

                cli
                mov     es,cs:seg_position      ; es=7000h (original segment)
                mov     sp,es:[00F2h]   ; restore stack pointer
                mov     ss,es:[00F0h]
                sti

                pop     es
                pop     ds
                popad
                popf
                RETF

ifdef   DIV0_ENABLE
Div0Recover:    
                pop     ax
                inc     ax
                inc     ax
                push    ax
                mov     dx,0000h
                mov     ax,0FFFFh
                IRET
endif
                DB      0
COM_PROGRAM_START       label   byte

code    ends
        end     start
