section .text
ORG 100h
	mov	ax,07000h
	push	ax
	popf
	pushf		;286だとここでbitが落ちる
	pop	ax	;8086 V30ならbitが上がる
	and	ax,0f000h
	jz	END	;0なら286リアルモード
	cmp	ax,0f000h	;F000なら8086orV30
	jne	continue
END:
	ret
continue:
	mov	dx,0cf8h
	mov	al,80h
	out	dx,al
	mov	dx,0c000h
	in	eax,dx
	cmp	ax,8086h
	je	Intel

	mov	dx,0cf8h
	mov	eax,80000000h
	out	dx,eax
	mov	dl,0fch
	in	eax,dx
	cmp	ax,8086h
	je	Intel
	cmp	ax,1004h
	je	VLSI
	cmp	eax,00051166h
	je	RCC				;;RCCの方法はITFを読んで見つけたので足しました
	mov	dl,0f8h
	mov	al,80h
	out	dx,al
					 ;Na7の例のやつはROM保管してなかったので探せません
	jmp	END

RCC:
	mov	dx,0cf8h
	mov	eax,80000078h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	or	al,2			;;78hのbit1
	cli
	out	dx,eax

	call	memcopy

	mov	dx,0cf8h
	mov	eax,80000078h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	and	al,~2
	out	dx,eax
	sti
	jmp	file

VLSI:					;;参考文献 https://www7b.biglobe.ne.jp/~marimo9821/util/wcram.html
	mov	dx,0cf8h
	mov	eax,80000064h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	or	eax,0AAAAh		;A0000hからBFFFFhまでをPCIRAM側読み出しへ
	cli			;割り込み禁止してもSMIが発生すれば取られる
	out	dx,eax

	call	memcopy

	mov	dx,0cf8h
	mov	eax,80000064h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	and	eax,0ffff0000h	;A0000hからBFFFFhまでを非PCI側(VRAM側)へ
	out	dx,eax
	sti
	jmp	file
Intel:
	cmp	eax,04a48086h	;;430LX
	je	mechanism2
	cmp	eax,04a38086h	;;430NX
	je	mechanism2

	mov	dx,0cf8h
	mov	eax,80000070h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	cli			;割り込み禁止してもSMIが発生すれば取られる
	or	eax,004a0000h		;A0000hからの128kB?にSMM出現
	out	dx,eax			;bit0-2は010b固定 bit6 open bit5 close bit4 lock bit3 enable

	call	memcopy

	mov	dx,0cf8h
	mov	eax,80000070h
	out	dx,eax
	mov	dx,0cfch
	in	eax,dx
	and	eax,0ff0fffffh		;A0000hからの64kBのSMMを切り離し(VRAMに戻る)
	out	dx,eax
	sti
file:
	push	cs
	pop	ds
	mov	dx,filename
	mov	ah,3ch
	int	21h
	jb	END
	mov	bx,ax
	mov	cx,8000h
	mov	dx,tocopy
	mov	ah,40h
	int	21h
	mov	ah,3eh
	int	21h
	mov	ah,4ch
	int	21h
	
mechanism2:;;
	mov	dx,0cf8h
	xor	al,al
	out	dx,al	;IO C000hからを閉めておく
	ret	;;72hの反応が以降機種と違う
		;;bit5 enable bit4 close bit3 lock bit0-2 addressとなっているが bit3のlock以外仕事をしていなさそう

memcopy:
	mov	cx,0a000h
	mov	ds,cx
	mov	di,tocopy
	push	cs
	pop	es
	mov	cx,2000h
	xor	si,si
rep	movsd			;;8000hの32kBだけ保管
	ret
filename:db "SMMSAVE.RAM",0
tocopy: