section .text
ORG 100h
	mov	ax,0ffe8h
	mov	es,ax
	cmp	word [es:0],2198h
	jne	normal
	cmp	byte [es:2h],80h
	jne	notfirstA
	cmp	byte [es:3fh],0
	jne	notHirezoBoard

	cli
	mov	bx,0f800h
	mov	ds,bx
	mov	dx,0c800h
	mov	es,dx
	xor	si,si
	xor	di,di
	mov	cx,4000h
rep	movsw			;c800hはハイレゾBIOS後半

	mov	dx,53dh
	mov	al,0		;RAM封印
	out	dx,al

	mov	dx,43dh
	mov	al,0h		;ROMを本体ハイレゾ側(と勝手に思っている)
	out	dx,al

	mov	dx,43fh
	mov	al,0e4h	;ハイレゾbank2
	out	dx,al

	mov	dx,0c000h
	mov	es,dx
	mov	fs,dx		;FS=C000h 前半 bank2 後半 ハイレゾBIOS
	xor	si,si
	xor	di,di
	mov	cx,4000h
rep	movsw			;c000hはハイレゾbank2

	mov	dx,43fh
	mov	al,0e8h	;ハイレゾbank4
	out	dx,al
	mov	dx,0d000h
	mov	es,dx
	mov	gs,dx		;GS=D000h bank4
	xor	si,si
	xor	di,di
	mov	cx,4000h
rep	movsw			;d000hはハイレゾbank4 ノーマルbank4と同じ内容
	
	mov	dx,43dh
	mov	al,2		;ROMを本体ノーマル側(と勝手に思っている)
	out	dx,al

	mov	dx,53dh
	mov	al,92h		;bit2を落とさないと行けない 忘れがち
	out	dx,al		;ハイレゾBIOSに戻しておく
	sti

	
	mov	di,6bh
	mov	si,start	;bank2のE02ロード部を改造
	mov	cx,codeend
	sub	cx,si
	push	cs
	pop	ds
	push	fs
	pop	es
rep	movsb

	mov	bx,8060h	;ハイレゾBIOSをパッチ
	mov	dword [fs:bx],0c0000000h	;jmp ffff:0000h to bank2 c000:7ff0 to c000:0000

	mov	bx,5fh		;bank2をパッチ
	mov	dword [fs:bx],0d0000000h	;jmp f800:0000 to bank4 d000:0000

	mov	bx,0f9ah	;bank4をパッチ
	mov	byte [gs:bx],0c0h	;jmp f800h:0003h to bank2 c000:0003h ここからE02ボードへ

	xor	ax,ax
	mov	es,ax
	mov	al,[es:5a7h]
	or	al,al
	jne	soundRAMon
;;	call	memtestwin	;したくないので省略
	test	byte [es:55dh],0fh
	je	noIDE
	mov	al,12h
	jmp	soundRAMon
noIDE:
	mov	al,02h
soundRAMon:
	or	al,80h
	mov	[es:5a7h],al

	mov	ax,4300h
	int	2fh
	cmp	al,80h
	je	XMSinstalled	;ハイレゾ非対応なメモリマネージャのことは無視します ちゃんとやりましょう

	mov	dx,91h
	mov	al,0ah
	out	dx,al
END:
	mov	dx,37h
	mov	al,0bh		;SHUT1=1  ハイレゾでは起動時に0になっているが通常リセットはこれ
	out	dx,al
	mov	al,0fh		;SHUT0=1
	out	dx,al
	jmp	0c800h:0000h	;ハイレゾBIOSでリセット実行
notHirezoBoard:
notfirstA:
normal:
	sti
	mov	ah,4ch
	int	21h

XMSinstalled:
	mov	dx,91h
	mov	al,08h
	out	dx,al
	jmp	END


start:;;shut0=1 shut0=0の状態ではこっちへ 本来は電源投入時の途中からの実行を早めに実行する
	call	readE02
	call	patchE02
	mov	dx,43dh
	mov	al,0
	out	dx,al		;F800セグメントにはハイレゾ用ITFローダを出現させておく
	jmp	1000h:0000h	;パッチされた内容で実行 ITF続行

patchE02:
	mov	bx,1000h
	mov	es,bx
;;	mov	byte [es:4027h],0ebh ;SHUT0が立ってるとSYSTEM SHTUDOWN表示するところへ行かせない
	or	byte [es:615bh],80h	;53dhへ発射する値に80hをorするだけ
	ret		;コードチェックなしのパッチなので危険は危険


readE02:
	mov	ah,0D0h	;文字第2コードはF0h ハイレゾBIOS
	cli			;E6、E7にはIDE ECにはSCSI? EEにもSCSIっぽい何か
	mov	dx,0a7h	;D0にいわゆるITFなコードが入っています。
	xor	al,al		;罫線色は全bit0
	out	dx,al
	mov	al,13h		;24dotフォント
	out	dx,al
	mov	dx,68h
	mov	al,0bh
	out	dx,al		;dotアクセスモード
	mov	dx,0ca1h
	mov	al,1
	out	dx,al		;ハイレゾボード上ROMへのアクセスON?
	mov	dx,0a3h
	mov	al,20h
	out	dx,al		;文字コード 第１を20hに選択 存在しない

	mov	bx,1000h	;1000hへ64kBロード
readloop:
	mov	dx,0e400h	;CGWindowに出現
	mov	ds,dx
	mov	dx,0a1h
	mov	al,ah
	out	dx,al
	mov	es,bx
	mov	cx,1000h
	xor	si,si
	xor	di,di
rep	movsb
	inc	ah
	add	bx,100h
	test	ah,0fh
	jne	readloop

	mov	dx,0ca1h
	mov	al,0		;ハイレゾボードROM アクセスOFF?
	out	dx,al
	mov	dx,68h
	mov	al,0ah		;コードアクセスモード
	out	dx,al
	ret
codeend:	
